<?php
/*------------------------------------*\
	External Modules/Files
\*------------------------------------*/

// Load KWD Marketing Styles
function html5blank_styles()
{
    wp_register_style('normalize', get_template_directory_uri() . '/normalize.css', array(), '1.0', 'all');
    wp_enqueue_style('normalize'); // Enqueue it!

	wp_register_style('uikitcss', 'https://cdnjs.cloudflare.com/ajax/libs/uikit/3.19.1/css/uikit.min.css', array(), '1.0', 'all');
    wp_enqueue_style('uikitcss'); // Enqueue it!

	wp_register_style('html5blank', get_template_directory_uri() . '/style.css', array(), '1.19', 'all');
    wp_enqueue_style('html5blank'); // Enqueue it!

	wp_register_script('uikitjs', 'https://cdnjs.cloudflare.com/ajax/libs/uikit/3.19.1/js/uikit.min.js', array('jquery'), '1.0.0'); // Custom scripts
    wp_enqueue_script('uikitjs'); // Enqueue it!

	wp_register_script('fontawesome', 'https://kit.fontawesome.com/c4d7b7d6e1.js', array('jquery'), '1.0.0'); // Custom scripts
    wp_enqueue_script('fontawesome'); // Enqueue it!
}

##Custom Theme Colours for Color Picker
/*function my_theme_gutenberg_color_palette() {
    add_theme_support( 'editor-color-palette', array(
        // Default Colors
        array(
            'name'  => __( 'Black', 'themeLangDomain' ),
            'slug'  => 'black',
            'color' => '#000000',
        ),
        array(
            'name'  => __( 'White', 'themeLangDomain' ),
            'slug'  => 'white',
            'color' => '#ffffff',
        ),
        // Add your custom colors here
        array(
            'name'  => __( 'Country Club Green', 'themeLangDomain' ),
            'slug'  => 'country-club-green',
            'color' => '#507f70',
        ),
        array(
            'name'  => __( 'Country Club Red', 'themeLangDomain' ),
            'slug'  => 'country-club-red',
            'color' => '#723637',
        ),
        array(
            'name'  => __( 'Country Club Blue', 'themeLangDomain' ),
            'slug'  => 'country-club-blue',
            'color' => '#517B8A',
        ),
        array(
            'name'  => __( 'Country Club Purple', 'themeLangDomain' ),
            'slug'  => 'country-club-purple',
            'color' => '#594754',
        ),
    ) );
}
add_action( 'after_setup_theme', 'my_theme_gutenberg_color_palette' );*/

//Add image to RSS feed
function featuredtoRSS( $content ) {
    global $post;

    // Check if the post has a featured image
    if ( has_post_thumbnail( $post->ID ) ) {
        $content = '<div>' . get_the_post_thumbnail( $post->ID, 'medium', array( 'style' => 'margin-bottom: 15px;' ) ) . '</div>' . $content;
    }

    return $content;
}

add_filter( 'the_excerpt_rss', 'featuredtoRSS' );
add_filter( 'the_content_feed', 'featuredtoRSS' );


//HIDES POSTS AREA
/*function remove_posts_menu() {
    remove_menu_page('edit.php');
}
add_action('admin_menu', 'remove_posts_menu');*/

//WooCommerce Thumbnail Features
//add_theme_support( 'wc-product-gallery-zoom' );
//add_theme_support( 'wc-product-gallery-lightbox' );
//add_theme_support( 'wc-product-gallery-slider' );

/**
 * Disable sending of the password change email
 */ 
add_filter( 'auto_plugin_update_send_email', '__return_false' );
add_filter( 'auto_theme_update_send_email', '__return_false' );
add_filter( 'send_password_change_email', '__return_false' );
if ( !function_exists( 'wp_password_change_notification' ) ) {
    function wp_password_change_notification() {}
}

/*fixes the post process image upload error.*/
add_filter( 'wp_image_editors', function() { return array( 'WP_Image_Editor_GD' ); } );

// Move Yoast to bottom
function yoasttobottom() {
	return 'low';
}
add_filter( 'wpseo_metabox_prio', 'yoasttobottom');

// Hide Draft Pages from the menu automatically
function imakeitwork_hide_unpublished_from_menu($items, $args) {
	 foreach ($items as $itemID => $object) {
	  	if ( (get_post_status($object->object_id)=='draft') || (get_post_status($object->object_id)=='private') )  {
	   		unset ($items[$itemID]);
	  }
 	}
 return $items;
}
add_filter ('wp_nav_menu_objects', 'imakeitwork_hide_unpublished_from_menu', 10, 2);

/*
 * Add Revision support to WooCommerce Products
 * 
 */

add_filter( 'woocommerce_register_post_type_product', 'cinch_add_revision_support' );

function cinch_add_revision_support( $supports ) {
     $supports['supports'][] = 'revisions';

     return $supports;
}



// Register Custom Post Type
function custom_reviews() {

    $labels = array(
        'name'                  => _x( 'Reviews', 'Post Type General Name', 'html5blank' ),
        'singular_name'         => _x( 'Review', 'Post Type Singular Name', 'html5blank' ),
        'menu_name'             => __( 'Reviews', 'html5blank' ),
        'name_admin_bar'        => __( 'Reviews', 'html5blank' ),
        'archives'              => __( 'Review Archives', 'html5blank' ),
        'attributes'            => __( 'Review Attributes', 'html5blank' ),
        'parent_item_colon'     => __( 'Parent Review:', 'html5blank' ),
        'all_items'             => __( 'All Reviews', 'html5blank' ),
        'add_new_item'          => __( 'Add New Review', 'html5blank' ),
        'add_new'               => __( 'Add New Review', 'html5blank' ),
        'new_item'              => __( 'New Review', 'html5blank' ),
        'edit_item'             => __( 'Edit Review', 'html5blank' ),
        'update_item'           => __( 'Update Review', 'html5blank' ),
        'view_item'             => __( 'View Review', 'html5blank' ),
        'view_items'            => __( 'View Reviews', 'html5blank' ),
        'search_items'          => __( 'Search Reviews', 'html5blank' ),
        'not_found'             => __( 'Not found', 'html5blank' ),
        'not_found_in_trash'    => __( 'Not found in Trash', 'html5blank' ),
        'featured_image'        => __( 'Featured Image', 'html5blank' ),
        'set_featured_image'    => __( 'Set featured image', 'html5blank' ),
        'remove_featured_image' => __( 'Remove featured image', 'html5blank' ),
        'use_featured_image'    => __( 'Use as featured image', 'html5blank' ),
        'insert_into_item'      => __( 'Insert into Review', 'html5blank' ),
        'uploaded_to_this_item' => __( 'Uploaded to this Review', 'html5blank' ),
        'items_list'            => __( 'Reviews list', 'html5blank' ),
        'items_list_navigation' => __( 'Reviews list navigation', 'html5blank' ),
        'filter_items_list'     => __( 'Filter Reviews list', 'html5blank' ),
    );

    $args = array(
        'label'                 => __( 'Review', 'html5blank' ),
        'description'           => __( 'Customer reviews and testimonials', 'html5blank' ),
        'labels'                => $labels,
        'show_in_rest'          => true,
        'supports'              => array( 'title', 'editor', 'revisions' ),
        'hierarchical'          => false,
        'has_archive'           => true,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 5,
        'menu_icon'             => 'dashicons-star-filled',
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'exclude_from_search'   => false,
        'publicly_queryable'    => true,
        'capability_type'       => 'post',
    );

    register_post_type( 'reviews', $args );

}
add_action( 'init', 'custom_reviews', 0 );


/*
function custom_services() {

	$labels = array(
		'name'                  => _x( 'Services', 'Post Type General Name', 'html5blank' ),
		'singular_name'         => _x( 'Service', 'Post Type Singular Name', 'html5blank' ),
		'menu_name'             => __( 'Services', 'html5blank' ),
		'name_admin_bar'        => __( 'Services', 'html5blank' ),
		'archives'              => __( 'Service Archives', 'html5blank' ),
		'attributes'            => __( 'Service Attributes', 'html5blank' ),
		'parent_item_colon'     => __( 'Parent Service:', 'html5blank' ),
		'all_items'             => __( 'All Service', 'html5blank' ),
		'add_new_item'          => __( 'Add New Service', 'html5blank' ),
		'add_new'               => __( 'Add New Service', 'html5blank' ),
		'new_item'              => __( 'New Service', 'html5blank' ),
		'edit_item'             => __( 'Edit Service', 'html5blank' ),
		'update_item'           => __( 'Update Service', 'html5blank' ),
		'view_item'             => __( 'View Service', 'html5blank' ),
		'view_items'            => __( 'View Services', 'html5blank' ),
		'search_items'          => __( 'Search Service', 'html5blank' ),
		'not_found'             => __( 'Not found', 'html5blank' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'html5blank' ),
		'featured_image'        => __( 'Featured Image', 'html5blank' ),
		'set_featured_image'    => __( 'Set featured image', 'html5blank' ),
		'remove_featured_image' => __( 'Remove featured image', 'html5blank' ),
		'use_featured_image'    => __( 'Use as featured image', 'html5blank' ),
		'insert_into_item'      => __( 'Insert into Service', 'html5blank' ),
		'uploaded_to_this_item' => __( 'Uploaded to this Service', 'html5blank' ),
		'items_list'            => __( 'Services list', 'html5blank' ),
		'items_list_navigation' => __( 'Services list navigation', 'html5blank' ),
		'filter_items_list'     => __( 'Filter Services list', 'html5blank' ),
	);
	$args = array(
		'label'                 => __( 'Service', 'html5blank' ),
		'description'           => __( 'Post Type Description', 'html5blank' ),
		'labels'                => $labels,
		'show_in_rest' 			=> true,
		'supports'              => array( 'title', 'editor','revisions' ),
		'hierarchical'          => false,
		'has_archive'			=> true,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'menu_icon'             => 'dashicons-format-chat',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'services', $args );

}
add_action( 'init', 'custom_services', 0 );
*/

/*
// Register Custom Taxonomy
function custom_taxonomy() {

	$labels = array(
		'name'                       => _x( 'Locations', 'Taxonomy General Name', 'text_domain' ),
		'singular_name'              => _x( 'Location', 'Taxonomy Singular Name', 'text_domain' ),
		'menu_name'                  => __( 'Add New Location', 'text_domain' ),
		'all_items'                  => __( 'Locations', 'text_domain' ),
		'parent_item'                => __( 'Location', 'text_domain' ),
		'parent_item_colon'          => __( 'Location:', 'text_domain' ),
		'new_item_name'              => __( 'Add New Location', 'text_domain' ),
		'add_new_item'               => __( 'Add New Location', 'text_domain' ),
		'edit_item'                  => __( 'Location', 'text_domain' ),
		'update_item'                => __( 'location', 'text_domain' ),
		'view_item'                  => __( 'location', 'text_domain' ),
		'separate_items_with_commas' => __( 'Separate items with commas', 'text_domain' ),
		'add_or_remove_items'        => __( 'Add or remove items', 'text_domain' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'text_domain' ),
		'popular_items'              => __( 'Popular Items', 'text_domain' ),
		'search_items'               => __( 'Search Items', 'text_domain' ),
		'not_found'                  => __( 'Not Found', 'text_domain' ),
		'no_terms'                   => __( 'No items', 'text_domain' ),
		'items_list'                 => __( 'Items list', 'text_domain' ),
		'items_list_navigation'      => __( 'Items list navigation', 'text_domain' ),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
		'show_in_rest' 			=> true,
	);
	register_taxonomy( 'location', array( 'members' ), $args );

}
add_action( 'init', 'custom_taxonomy', 0 );


*/

if ( ! function_exists( 'wp_body_open' ) ) {
    function wp_body_open() {
        do_action( 'wp_body_open' );
    }
}



// Update phone number sitewide through Appearance → Customize → Contact Information.
function theme_customize_register($wp_customize) {
    $wp_customize->add_section('contact_info_section', array(
        'title'    => 'Contact Information',
        'priority' => 30,
    ));

    $wp_customize->add_setting('site_phone_number', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('site_phone_number', array(
        'label'   => 'Phone Number',
        'section' => 'contact_info_section',
        'type'    => 'text',
    ));
}
add_action('customize_register', 'theme_customize_register'); // Ensure this line is present!

// Function to get the phone number
function get_site_phone_number() {
    return get_theme_mod('site_phone_number', 'No phone number set');
}





// Update CSS within in Admin
function admin_style() {
  wp_enqueue_style('admin-styles', get_template_directory_uri().'/admin.css');
}
add_action('admin_enqueue_scripts', 'admin_style');

/*Verify we have a woocommerce.php file in our theme.*/
add_action( 'after_setup_theme', 'woocommerce_support' );
function woocommerce_support() {
    add_theme_support( 'woocommerce' );
}
/*Remove Product Notices*/
remove_action( 'admin_notices', 'woothemes_updater_notice' );

function my_login_logo() { ?>
    <style type="text/css">
        body.login div#login h1 a {
		background-image: url(<?php echo get_stylesheet_directory_uri(); ?>/images/site-login-logo.png);
		padding-bottom: 30px;
		background-size: 300px!important;
		width:300px!important
        }
	.login form {
		background: #0590F1;
		border-radius: 10px;
	}

	.login label {
		color: #fff;
	}
	#login .input{
		background-color:#fff!important;
	}
	#login input[type=submit] {
		background-color:#fff;
		border-radius:8px;
		border:none;
		color:#0590F1;
	}
    </style>
<?php }
add_action( 'login_enqueue_scripts', 'my_login_logo' );


function my_login_logo_url() {
    return 'https://kelownawebsitedesign.com/';
}
add_filter( 'login_headerurl', 'my_login_logo_url' );

function my_login_logo_url_title() {
    return 'Kelowna Website Design';
}
add_filter( 'login_headertext', 'my_login_logo_url_title' );

/*------------------------------------*\
	Theme Support
\*------------------------------------*/

if (!isset($content_width))
{
    $content_width = 1400;
}

// Add Theme Support Features

// Enable support for menus
add_theme_support('menus');

// Enable support for post thumbnails
add_theme_support('post-thumbnails');

// Define custom image sizes
add_image_size('large', 2000, 2000, true); // Large Thumbnail
add_image_size('medium', 1250, 1250, true); // Medium Thumbnail
add_image_size('small', 500, 500, true);   // Small Thumbnail
add_image_size('custom-size', 750, 400, true); // Custom Thumbnail Size for use with the_post_thumbnail('custom-size')

// Enable RSS feed links in head
add_theme_support('automatic-feed-links');



/*------------------------------------*\
	Functions
\*------------------------------------*/

// HTML5 Blank navigation
function html5blank_nav()
{
	wp_nav_menu(
	array(
		'theme_location'  => 'header-menu',
		'menu'            => '',
		'container'       => 'div',
		'container_class' => 'menu-{menu slug}-container',
		'container_id'    => '',
		'menu_class'      => 'menu',
		'menu_id'         => '',
		'echo'            => true,
		'fallback_cb'     => 'wp_page_menu',
		'before'          => '',
		'after'           => '',
		'link_before'     => '',
		'link_after'      => '',
		'items_wrap'      => '<ul>%3$s</ul>',
		'depth'           => 0,
		'walker'          => ''
		)
	);
}

function html5blank_footer()
{
	wp_nav_menu(
	array(
		'theme_location'  => 'footer-menu',
		'menu'            => '',
		'container'       => 'div',
		'container_class' => 'menu-{menu slug}-container',
		'container_id'    => '',
		'menu_class'      => 'menu',
		'menu_id'         => '',
		'echo'            => true,
		'fallback_cb'     => 'wp_page_menu',
		'before'          => '',
		'after'           => '',
		'link_before'     => '',
		'link_after'      => '',
		'items_wrap'      => '<ul class="uk-list foot_list uk-column-1-2@m">%3$s</ul>',
		'depth'           => 0,
		'walker'          => ''
		)
	);
}

function html5blank_mobile()
{
	wp_nav_menu(
	array(
		'theme_location'  => 'mobile-header',
		'menu'            => '',
		'container'       => 'div',
		'container_class' => 'menu-{menu slug}-container',
		'container_id'    => '',
		'menu_class'      => 'menu',
		'menu_id'         => '',
		'echo'            => true,
		'fallback_cb'     => 'wp_page_menu',
		'before'          => '',
		'after'           => '',
		'link_before'     => '',
		'link_after'      => '',
		'items_wrap'      => '<ul>%3$s</ul>',
		'depth'           => 0,
		'walker'          => ''
		)
	);
}

// Load HTML5 Blank scripts (header.php)
function html5blank_header_scripts() {
    // Ensure scripts are not loaded on login page or in admin area
    if (!is_admin() && $GLOBALS['pagenow'] !== 'wp-login.php') {
        // Register Conditionizr
        wp_register_script(
            'conditionizr',
            get_template_directory_uri() . '/js/lib/conditionizr-4.3.0.min.js',
            array(),
            '4.3.0',
            false // Load in the footer
        );
        wp_enqueue_script('conditionizr');

        // Register Modernizr
        wp_register_script(
            'modernizr',
            get_template_directory_uri() . '/js/lib/modernizr-2.7.1.min.js',
            array(),
            '2.7.1',
            false // Load in the header
        );
        wp_enqueue_script('modernizr');

        // Register custom scripts
        wp_register_script(
            'html5blankscripts',
            get_template_directory_uri() . '/js/scripts.js',
            array('jquery'), // Dependencies
            '1.0.0',
            true // Load in the footer
        );
        wp_enqueue_script('html5blankscripts');
    }
}
add_action('wp_enqueue_scripts', 'html5blank_header_scripts');

add_action('wp_footer', function() {
    echo "<script>
        conditionizr.config({
            assets: '" . get_template_directory_uri() . "',
            tests: {}
        });
    </script>";
}, 100);

// Load HTML5 Blank conditional scripts
function html5blank_conditional_scripts()
{
    if (is_page('pagenamehere')) {
        wp_register_script('scriptname', get_template_directory_uri() . '/js/scriptname.js', array('jquery'), '1.0.0'); // Conditional script(s)
        wp_enqueue_script('scriptname'); // Enqueue it!
    }
}

// Register HTML5 Blank Navigation
function register_html5_menu()
{
    register_nav_menus(array( // Using array to specify more menus if needed
        'header-menu' => __('Header Menu', 'html5blank'), // Main Navigation
        'mobile-menu' => __('Mobile Menu', 'html5blank'), // Sidebar Navigation
        'footer-menu' => __('Footer Menu', 'html5blank') // Extra Navigation if needed (duplicate as many as you need!)
    ));
}



// Remove the <div> surrounding the dynamic navigation to cleanup markup
function my_wp_nav_menu_args($args = '')
{
    $args['container'] = false;
    return $args;
}

// Remove Injected classes, ID's and Page ID's from Navigation <li> items
function my_css_attributes_filter($var)
{
    return is_array($var) ? array() : '';
}

// Remove invalid rel attribute values in the categorylist
function remove_category_rel_from_category_list($thelist)
{
    return str_replace('rel="category tag"', 'rel="tag"', $thelist);
}

// Add page slug to body class, love this - Credit: Starkers Wordpress Theme
function add_slug_to_body_class($classes)
{
    global $post;
    if (is_home()) {
        $key = array_search('blog', $classes);
        if ($key > -1) {
            unset($classes[$key]);
        }
    } elseif (is_page()) {
        $classes[] = sanitize_html_class($post->post_name);
    } elseif (is_singular()) {
        $classes[] = sanitize_html_class($post->post_name);
    }

    return $classes;
}

// If Dynamic Sidebar Exists
if (function_exists('register_sidebar'))
{
    // Define Sidebar Widget Area 1
    register_sidebar(array(
        'name' => __('Widget Area 1', 'html5blank'),
        'description' => __('Description for this widget-area...', 'html5blank'),
        'id' => 'widget-area-1',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));

    // Define Sidebar Widget Area 2
    register_sidebar(array(
        'name' => __('Widget Area 2', 'html5blank'),
        'description' => __('Description for this widget-area...', 'html5blank'),
        'id' => 'widget-area-2',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));
}

// Remove wp_head() injected Recent Comment styles
function my_remove_recent_comments_style()
{
    global $wp_widget_factory;
    remove_action('wp_head', array(
        $wp_widget_factory->widgets['WP_Widget_Recent_Comments'],
        'recent_comments_style'
    ));
}

// Pagination for paged posts, Page 1, Page 2, Page 3, with Next and Previous Links, No plugin
function html5wp_pagination()
{
    global $wp_query;
    $big = 999999999;
    echo paginate_links(array(
        'base' => str_replace($big, '%#%', get_pagenum_link($big)),
        'format' => '?paged=%#%',
        'current' => max(1, get_query_var('paged')),
        'total' => $wp_query->max_num_pages
    ));
}

// Custom Excerpts
function html5wp_index($length) // Create 20 Word Callback for Index page Excerpts, call using html5wp_excerpt('html5wp_index');
{
    return 60;
}

// Create 40 Word Callback for Custom Post Excerpts, call using html5wp_excerpt('html5wp_custom_post');
function html5wp_custom_post($length)
{
    return 40;
}

// Create the Custom Excerpts callback
function html5wp_excerpt($length_callback = '', $more_callback = '')
{
    global $post;
    if (function_exists($length_callback)) {
        add_filter('excerpt_length', $length_callback);
    }
    if (function_exists($more_callback)) {
        add_filter('excerpt_more', $more_callback);
    }
    $output = get_the_excerpt();
    $output = apply_filters('wptexturize', $output);
    $output = apply_filters('convert_chars', $output);
    $output = '<p>' . $output . '</p>';
    echo $output;
}

// Custom View Article link to Post
function html5_blank_view_article($more)
{
    global $post;
    return '... <a class="view-article" href="' . get_permalink($post->ID) . '">' . __('View Article', 'html5blank') . '</a>';
}

// Remove Admin bar
function remove_admin_bar()
{
    return false;
}

// Remove 'text/css' from our enqueued stylesheet
function html5_style_remove($tag)
{
    return preg_replace('~\s+type=["\'][^"\']++["\']~', '', $tag);
}

// Remove thumbnail width and height dimensions that prevent fluid images in the_thumbnail
function remove_thumbnail_dimensions( $html )
{
    $html = preg_replace('/(width|height)=\"\d*\"\s/', "", $html);
    return $html;
}

// Custom Gravatar in Settings > Discussion
function html5blankgravatar ($avatar_defaults)
{
    $myavatar = get_template_directory_uri() . '/img/gravatar.jpg';
    $avatar_defaults[$myavatar] = "Custom Gravatar";
    return $avatar_defaults;
}

// Threaded Comments
function enable_threaded_comments()
{
    if (!is_admin()) {
        if (is_singular() AND comments_open() AND (get_option('thread_comments') == 1)) {
            wp_enqueue_script('comment-reply');
        }
    }
}

// Custom Comments Callback
function html5blankcomments($comment, $args, $depth)
{
	$GLOBALS['comment'] = $comment;
	extract($args, EXTR_SKIP);

	if ( 'div' == $args['style'] ) {
		$tag = 'div';
		$add_below = 'comment';
	} else {
		$tag = 'li';
		$add_below = 'div-comment';
	}
?>
    <!-- heads up: starting < for the html tag (li or div) in the next line: -->
    <<?php echo $tag ?> <?php comment_class(empty( $args['has_children'] ) ? '' : 'parent') ?> id="comment-<?php comment_ID() ?>">
	<?php if ( 'div' != $args['style'] ) : ?>
	<div id="div-comment-<?php comment_ID() ?>" class="comment-body">
	<?php endif; ?>
	<div class="comment-author vcard">
	<?php if ($args['avatar_size'] != 0) echo get_avatar( $comment, $args['180'] ); ?>
	<?php printf(__('<cite class="fn">%s</cite> <span class="says">says:</span>'), get_comment_author_link()) ?>
	</div>
<?php if ($comment->comment_approved == '0') : ?>
	<em class="comment-awaiting-moderation"><?php _e('Your comment is awaiting moderation.') ?></em>
	<br />
<?php endif; ?>

	<div class="comment-meta commentmetadata"><a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>">
		<?php
			printf( __('%1$s at %2$s'), get_comment_date(),  get_comment_time()) ?></a><?php edit_comment_link(__('(Edit)'),'  ','' );
		?>
	</div>

	<?php comment_text() ?>

	<div class="reply">
	<?php comment_reply_link(array_merge( $args, array('add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
	</div>
	<?php if ( 'div' != $args['style'] ) : ?>
	</div>
	<?php endif; ?>
<?php }

/*------------------------------------*\
	Actions + Filters + ShortCodes
\*------------------------------------*/

// Add Actions
add_action('init', 'html5blank_header_scripts'); // Add Custom Scripts to wp_head
add_action('wp_print_scripts', 'html5blank_conditional_scripts'); // Add Conditional Page Scripts
add_action('get_header', 'enable_threaded_comments'); // Enable Threaded Comments
add_action('wp_enqueue_scripts', 'html5blank_styles'); // Add Theme Stylesheet
add_action('init', 'register_html5_menu'); // Add HTML5 Blank Menu
add_action('widgets_init', 'my_remove_recent_comments_style'); // Remove inline Recent Comment Styles from wp_head()
add_action('init', 'html5wp_pagination'); // Add our HTML5 Pagination

// Remove Actions
remove_action('wp_head', 'feed_links_extra', 3); // Display the links to the extra feeds such as category feeds
remove_action('wp_head', 'feed_links', 2); // Display the links to the general feeds: Post and Comment Feed
remove_action('wp_head', 'rsd_link'); // Display the link to the Really Simple Discovery service endpoint, EditURI link
remove_action('wp_head', 'wlwmanifest_link'); // Display the link to the Windows Live Writer manifest file.
remove_action('wp_head', 'index_rel_link'); // Index link
remove_action('wp_head', 'parent_post_rel_link', 10, 0); // Prev link
remove_action('wp_head', 'start_post_rel_link', 10, 0); // Start link
remove_action('wp_head', 'adjacent_posts_rel_link', 10, 0); // Display relational links for the posts adjacent to the current post.
remove_action('wp_head', 'wp_generator'); // Display the XHTML generator that is generated on the wp_head hook, WP version
remove_action('wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);
remove_action('wp_head', 'rel_canonical');
remove_action('wp_head', 'wp_shortlink_wp_head', 10, 0);

// Add Filters
add_filter('avatar_defaults', 'html5blankgravatar'); // Custom Gravatar in Settings > Discussion
add_filter('body_class', 'add_slug_to_body_class'); // Add slug to body class (Starkers build)
add_filter('widget_text', 'do_shortcode'); // Allow shortcodes in Dynamic Sidebar
add_filter('widget_text', 'shortcode_unautop'); // Remove <p> tags in Dynamic Sidebars (better!)
add_filter('wp_nav_menu_args', 'my_wp_nav_menu_args'); // Remove surrounding <div> from WP Navigation
// add_filter('nav_menu_css_class', 'my_css_attributes_filter', 100, 1); // Remove Navigation <li> injected classes (Commented out by default)
// add_filter('nav_menu_item_id', 'my_css_attributes_filter', 100, 1); // Remove Navigation <li> injected ID (Commented out by default)
// add_filter('page_css_class', 'my_css_attributes_filter', 100, 1); // Remove Navigation <li> Page ID's (Commented out by default)
add_filter('the_category', 'remove_category_rel_from_category_list'); // Remove invalid rel attribute
add_filter('the_excerpt', 'shortcode_unautop'); // Remove auto <p> tags in Excerpt (Manual Excerpts only)
add_filter('the_excerpt', 'do_shortcode'); // Allows Shortcodes to be executed in Excerpt (Manual Excerpts only)
add_filter('excerpt_more', 'html5_blank_view_article'); // Add 'View Article' button instead of [...] for Excerpts
add_filter('show_admin_bar', 'remove_admin_bar'); // Remove Admin bar
add_filter('style_loader_tag', 'html5_style_remove'); // Remove 'text/css' from enqueued stylesheet
add_filter('post_thumbnail_html', 'remove_thumbnail_dimensions', 10); // Remove width and height dynamic attributes to thumbnails
add_filter('image_send_to_editor', 'remove_thumbnail_dimensions', 10); // Remove width and height dynamic attributes to post images

// Remove Filters
remove_filter('the_excerpt', 'wpautop'); // Remove <p> tags from Excerpt altogether

// Shortcodes
add_shortcode('html5_shortcode_demo', 'html5_shortcode_demo'); // You can place [html5_shortcode_demo] in Pages, Posts now.
add_shortcode('html5_shortcode_demo_2', 'html5_shortcode_demo_2'); // Place [html5_shortcode_demo_2] in Pages, Posts now.

// Shortcodes above would be nested like this -
// [html5_shortcode_demo] [html5_shortcode_demo_2] Here's the page title! [/html5_shortcode_demo_2] [/html5_shortcode_demo]



/*------------------------------------*\
	ShortCode Functions
\*------------------------------------*/

// Shortcode Demo with Nested Capability
function html5_shortcode_demo($atts, $content = null)
{
    return '<div class="shortcode-demo">' . do_shortcode($content) . '</div>'; // do_shortcode allows for nested Shortcodes
}

// Shortcode Demo with simple <h2> tag
function html5_shortcode_demo_2($atts, $content = null) // Demo Heading H2 shortcode, allows for nesting within above element. Fully expandable.
{
    return '<h2>' . $content . '</h2>';
}

?>
<?php
// Add this code to your functions.php file

add_filter('gform_pre_render', 'populate_vehicle_make_and_year');
add_filter('gform_pre_validation', 'populate_vehicle_make_and_year');
add_filter('gform_pre_submission_filter', 'populate_vehicle_make_and_year');
add_filter('gform_admin_pre_render', 'populate_vehicle_make_and_year');

function populate_vehicle_make_and_year($form) {
    foreach ($form['fields'] as &$field) {
        // Populate Vehicle Make dropdown
        if ($field->type == 'select' && strpos($field->label, 'Vehicle Make') !== false) {
            $vehicle_makes = [
                'ACURA', 'AUDI', 'BMW', 'BUICK', 'CADILLAC', 'CHEVROLET', 'CHRYSLER', 'DODGE', 
                'FORD', 'GMC', 'HONDA', 'HUMMER', 'HYUNDAI', 'INFINITI', 'ISUZU', 'JEEP', 'KIA', 
                'LAND ROVER', 'LEXUS', 'LINCOLN', 'MAZDA', 'MERCEDES-BENZ', 'MERCURY', 'MINI', 
                'MITSUBISHI', 'NISSAN', 'PLYMOUTH', 'PONTIAC', 'SAAB', 'SATURN', 'SCION', 'SUBARU', 
                'SUZUKI', 'TOYOTA', 'VOLKSWAGEN', 'VOLVO'
            ];

            foreach ($vehicle_makes as $make) {
                $field->choices[] = [
                    'text'  => $make,
                    'value' => $make
                ];
            }
        }

        // Populate Year dropdown
        if ($field->type == 'select' && strpos($field->label, 'Year') !== false) {
            $years = range(2025, 1950);

            foreach ($years as $year) {
                $field->choices[] = [
                    'text'  => $year,
                    'value' => $year
                ];
            }
        }
    }

    return $form;
}
