<?php /*template name: Gallery*/ get_header(); ?>

<div class="uk-container">
	<main role="main">
		<section>

			<h1><?php the_title(); ?></h1>
 <?php 

        $images = get_field('gallery');

        if( $images ): ?>
            <ul uk-lightbox uk-grid class="uk-child-width-1-4@m uk-child-width-1-2"  uk-scrollspy="cls:uk-animation-fade">
                <?php foreach( $images as $image ): ?>
                    <li >
                        <a href="<?php echo $image['url']; ?>">
                             <img src="<?php echo $image['sizes']['medium']; ?>" alt="<?php echo $image['alt']; ?>" />
                        </a>
                        <p><?php echo $image['caption']; ?></p>
                    </li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
		
			<?php if (have_posts()): while (have_posts()) : the_post(); ?>

				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

					<?php the_content(); ?>

					<br class="clear">

					<?php edit_post_link( __('Edit this page'), '', '', 0, 'post-edit-link uk-label uk-float-right' ); ?>

				</article>

			<?php endwhile; ?><?php endif; ?>

		</section>
	</main>
</div>
<?php get_footer(); ?>
