<!doctype html>
<html <?php language_attributes(); ?> class="no-js">
	<head>
		<meta charset="<?php bloginfo('charset'); ?>">
		<title><?php wp_title(''); ?></title>

		<link href="//www.google-analytics.com" rel="dns-prefetch">

		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">

		<?php wp_head(); ?>


		<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
		<link href="https://fonts.googleapis.com/css2?family=Barlow:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
		<link href='//fonts.googleapis.com/css?family=Open+Sans:300italic,400italic,600italic,700italic,800italic,400,300,600,700,800' rel='stylesheet' type='text/css'>

	</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-JWCQVCWC69"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-JWCQVCWC69');
  gtag('config', 'G-1JSFYHC9PW');
  gtag('config', 'AW-10793360248');
  gtag('config', 'UA-193565383-58');
</script>

<script>
    window.onload = function () {
        const timestamp = new Date().getTime();

        // Load the script
        const script = document.createElement('script');
        script.src = `https://booking.tekmetric.com/iframe/modal.js?time=${timestamp}`;
        script.defer = true;
        document.body.appendChild(script);

        // Load the stylesheet
        const link = document.createElement('link');
        link.rel = 'stylesheet';
        link.href = `https://booking.tekmetric.com/iframe/modal.css?time=${timestamp}`;
        document.head.appendChild(link);
    };
</script>

		<div class="wrapper">

<div id="mobile_nav" uk-offcanvas="flip: true">
	<div class="uk-offcanvas-bar">
		<p class="uk-text-center">
			<a href="<?php echo home_url(); ?>" class="">
				<img class="logo" src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt="Logo">
			</a>
		</p>
		<h5 class="uk-text-bold uk-text-center"><a class="lt-blue" href="<?php echo esc_html(get_site_phone_number()); ?>"><?php echo esc_html(get_site_phone_number()); ?></a></h5>
		<h6 class="uk-margin-remove-top uk-text-center">12865 141 St NW<br>Edmonton, AB T5L 4N1</h6>
		<?php html5blank_nav(); ?>
		<a class="btn white" href="#" onclick="onShowBooking('5e64cce8-0654-4478-9933-ea9050a1f859')">Book An Appointment</a>
	</div>
</div>

			<header class="header clear" role="banner">
				<div class="uk-container uk-container-large">
					<div class="uk-flex uk-flex-middle uk-grid-small uk-text-left@m uk-text-center" uk-grid>
						<div class="uk-width-1-1 uk-width-auto@m">
							<a href="<?php echo home_url(); ?>">
								<img class="logo" src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt="Logo">
							</a>

						</div>
						<div class="uk-width-1-1 uk-width-expand@m">

							<div class="uk-child-width-1-3@m uk-grid-small uk-flex uk-flex-middle" uk-grid>
								<div class="uk-text-center">
									<p class="uk-margin-remove-bottom uk-margin-top">Edmonton Auto Repair</p>
									<p class="uk-margin-remove"><i class="fa-solid gold fa-star"></i> <i class="fa-solid gold fa-star"></i> <i class="fa-solid gold fa-star"></i> <i class="fa-solid gold fa-star"></i> <i class="fa-solid gold fa-star"></i> <a href="<?= home_url(); ?>/reviews/">315 reviews</a></p>
									<h6 class="uk-margin-remove">	Mon - Fri: 8:00 AM - 5:00 PM</h6>

								</div>
								<div class="uk-text-center">
									<h5 class="uk-text-bold uk-margin-remove-bottom ">Call Us: <a class="lt-blue" href="<?php echo esc_html(get_site_phone_number()); ?>"><?php echo esc_html(get_site_phone_number()); ?></a></h5>
									<h6 class="uk-margin-remove">12865 141 St NW<br>Edmonton, AB T5L 4N1</h6>
								</div>
								<div class="uk-text-center uk-text-right@m">
									<a class="btn uk-margin-top" href="#" onclick="onShowBooking('5e64cce8-0654-4478-9933-ea9050a1f859')">Book An Appointment</a>
								</div>
								
							</div>	
							<nav class="nav uk-visible@m" role="navigation">
								<?php html5blank_nav(); ?>
							</nav>

							<a class="uk-position-top-right uk-hidden@m menu_pointer" href="#mobile_nav" uk-toggle>
								<i class="far fa-bars fa-2x"></i>
							</a>
						</div>
					</div>
				</div>
			</header>
