<?php /* Template Name: Homepage */ get_header(); ?>
<?php if( get_field('advertising_title')): ?>
	<div class="uk-container uk-container-large uk-margin advertising">	 
		<div class="uk-flex-center uk-flex">
		<div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>
			<div class="uk-width-auto">
				<i class="fa-solid fa-bell fa-3x blue"></i>
			</div>
			<div class="uk-width-expand">
					<h2 class="blue uk-margin-remove"><?= get_field('advertising_title'); ?></h2>
					<h5 class="uk-margin-remove"><?= get_field('advertising_text'); ?></h5>
					<?php /* <a href="https://edmontonchassis.ca/appointments?coupon=1" title="Redeem Now" class="btn"> Redeem Now </a> */ ?>
			</div>
		</div>
		</div>
	</div>
<?php endif; ?>
<div class="uk-cover-container uk-text-center banner">
    <canvas class="uk-visible@m" width="" height="644"></canvas>
    <canvas class="uk-hidden@m" width="" height="300"></canvas>
	
	<?php if( get_field('main_banner') ){ ?>
		<img uk-img data-src="<?php the_field('main_banner'); ?>" data-width data-height uk-cover>
	<?php } else { ?>
		<img uk-img data-src="<?php echo get_template_directory_uri(); ?>/images/Edmonton-new-slide-view11.png" data-width data-height uk-cover>
	<?php } ?>

	 <div class="uk-overlay-primary uk-position-cover"></div>

	<div class="uk-position-cover uk-text-center uk-container uk-flex uk-flex-bottom">
        <div class="uk-width-1-1">
			  <div class="uk-grid-small uk-grid-match uk-child-width-1-5@m uk-text-center white uk-visible@m" uk-grid>
				<div>
					<div class="blue-bg">
						<img uk-img data-src="<?php echo get_template_directory_uri(); ?>/images/car.png" data-width data-height><br>Same Day Service on Most Vehicles
					</div>
				</div>
				  <div>
					<div class="blue-bg">
						<img uk-img data-src="<?php echo get_template_directory_uri(); ?>/images/detailing.png" data-width data-height><br>Full Automotive <br>Repair
					</div>
				</div>
				<div>
					<div class="blue-bg">
						<img uk-img data-src="<?php echo get_template_directory_uri(); ?>/images/check-up.png" data-width data-height><br>Salvage Inspections &amp; Repairs
					</div>
				</div>
				<div>
					<div class="blue-bg">
						<img uk-img data-src="<?php echo get_template_directory_uri(); ?>/images/hand.png" data-width data-height><br>Auto Repair Financing Available
					</div>
				</div>
				<div>
					<div class="blue-bg">
						<img uk-img data-src="<?php echo get_template_directory_uri(); ?>/images/Deal.png" data-width data-height><br>Secure After Hours Key Drop
					</div>
				</div>
				
			  </div>
			  <div class="blue-bg uk-text-center white"><h4 class="white"><i class="fa-duotone fa-solid fa-sack-dollar"></i> Edmonton Chassis offers financing for auto repair services. Give us a call for details!</h4></div>
        </div>
    </div>
</div>



<div class="blue-bg uk-hidden@m uk-padding-small">
<div class="uk-container uk-container-large">
<div class="uk-grid-small uk-grid-match white uk-child-width-1-2 uk-text-center " uk-grid>
	<div>
		<div class="">
			<img uk-img data-src="<?php echo get_template_directory_uri(); ?>/images/car.png" data-width data-height><br>Same Day Service on Most Vehicles
		</div>
	</div>
	<div>
		<div class="">
			<img uk-img data-src="<?php echo get_template_directory_uri(); ?>/images/detailing.png" data-width data-height><br>Full Automotive Repair
		</div>
	</div>
	<div>
		<div class="">
			<img uk-img data-src="<?php echo get_template_directory_uri(); ?>/images/check-up.png" data-width data-height><br>Salvage Inspections &amp; Repairs
		</div>
	</div>
	<div>
		<div class="">
			<img uk-img data-src="<?php echo get_template_directory_uri(); ?>/images/Deal.png" data-width data-height><br>Secure After Hours Key Drop
		</div>
	</div>
	
  </div>
 </div>
 </div>




			<div class="testimonials-section">
				
				<div class="uk-container uk-container-large">
					<div uk-grid>
						<div class="uk-width-3-5@m">
							<h1>Customer Reviews</h1>
							<?php

     // WP_Query arguments
     $args = array(
       'post_type'              => array( 'reviews' ),
	   'posts_per_page'         => '6',
	   'orderby'         => 'rand',
     );

     // The Query
     $querys = new WP_Query( $args );

     // The Loop
     if ( $querys->have_posts() ) { ?>
	 
	 <div uk-slider="autoplay: true">
		<div class="uk-slider-items uk-child-width-1-1">
		
       <?php while ( $querys->have_posts() ) {
         $querys->the_post();?>
			<div>
			<h6 class="uk-text-italic"><?php the_content();?></h6>
			
			<h6 class="uk-margin-remove"><span class="uk-text-bold uk-margin-small-right"><?php the_title(); ?></span> <i class="fa-solid gold fa-star"></i> <i class="fa-solid gold fa-star"></i> <i class="fa-solid gold fa-star"></i> <i class="fa-solid gold fa-star"></i> <i class="fa-solid gold fa-star"></i> <a class="uk-margin-small-left" href="<?= home_url(); ?>/reviews/">See All Reviews</a></h6>
			</div>
			 <?php } ?>
			 
		</div> 
		<div class="uk-text-right@m uk-text-center">
						<a href uk-slider-item="previous"><i class="fa-regular fa-circle-left fa-2x"></i></a>
						<a href uk-slider-item="next"><i class="fa-regular fa-circle-right fa-2x"></i></a>
					</div>
	</div> 
     <?php } else {
       // no posts found
     }

     // Restore original Post Data
     wp_reset_postdata();
      ?>
	  
						</div>
						<div class="uk-width-2-5@m">
							<img uk-img data-src="<?php echo get_template_directory_uri(); ?>/images/reviews-stock-img.png" data-width data-height>
						</div>
					</div>
					 
				</div>
			</div>
	

	<?php 
	$images = get_field('gallery_homepage');
	if( $images ): ?>
	<div class="uk-container uk-container-large">
		<div class="gallery">
			<div class="uk-grid-collapse uk-child-width-1-5" uk-grid uk-lightbox>
				<?php foreach( $images as $image ): ?>
					<div>
						<a href="<?php echo esc_url($image['url']); ?>">
							 <img uk-img data-src="<?php echo esc_url($image['sizes']['medium']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" />
						</a>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
	</div>
	<?php endif; ?>


	<div class="uk-container uk-container-large">
		<div class="uk-child-width-1-2@m uk-grid-divider uk-margin-large-top uk-margin-large-bottom" uk-grid>
			<div>
				<h2>Welcome to Edmonton Chassis</h2>
				<p>Founded in 2005, Edmonton Chassis Auto Repair &amp; Inspections has provided vehicle owners all over Edmonton, Alberta, with the reliable and dependable auto care. We want our customers to drive with confidence, and we work hard to keep your vehicle running smoothly. We are committed to our customers and the longevity of your vehicle. Our technicians have more than 130 combined years of hands-on experience and we are here to serve the community with quality repairs. We don't offer extravagant service packages with unnecessary services, we don't have obnoxious in-your-face marketing tactics and our straightforward approach puts our customers at ease. Our thorough approach to diagnosing issues with your vehicle and our ability to perform a wide range of services, ensures that you get the best quality of service with each visit. We do the hard work necessary to help you achieve the success you want and you can trust that we will never take shortcuts.</p> 
				<div class="uk-grid-small uk-flex-middle" uk-grid>
					<div class="uk-width-1-2">
						<a class="btn" href="<?php echo home_url(); ?>/appointments">Make An Appointment</a>
					</div>
					<div class="uk-width-1-2 uk-flex uk-flex-right uk-visible@m">
						<img uk-img data-src="<?php echo get_template_directory_uri(); ?>/images/9_Best_Truck_Repair_in_Edmonton__2022__.png" data-width data-height>
					</div>
				</div>

			</div>
			<div>
				<h2>We Work on All Makes &amp; Models</h2>
				<p>Our shop is a full-service auto repair facility and we service all makes and models. We are licensed by The Alberta Motor Vehicle Industry Council, The City of Edmonton, and Alberta Transportation to offer salvage and "out-of-province" inspections. We offer a comprehensive list of services that include general repair, preventative maintenance, brake repair, tire services, vehicle inspections, collision repair, engine repair, and more. If you don't think you can afford a service, feel free to chat with our team and they'll review our financing options with you. Costs should never get in the way of driving a quality vehicle, and we will work with you to find the right solution for your situation. We also accept walk-ins and offer same-day turnaround for many services, so feel free to visit us on 12865 141 Street NW at a time that fits your schedule. If you prefer to schedule an appointment, give us a call at (825) 525-2727 and we are happy to help.	</p>
				<a class="btn" href="<?php echo home_url(); ?>/vehicles">VEHICLES WE SERVICE</a>
			</div>
		</div>
		
		<?php 
	$images = get_field('logos');
	if( $images ): ?>

		<div class="gallery uk-width-2-3@m uk-margin-auto">
			<div class="uk-grid-small uk-child-width-auto@m uk-child-width-1-2 uk-flex uk-flex-center uk-flex-middle" uk-grid>
				<?php foreach( $images as $image ): ?>
					<div>
						<img uk-img data-src="<?php echo esc_url($image['sizes']['medium']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" />
					</div>
				<?php endforeach; ?>
			</div>
		</div>

	<?php endif; ?>
</div>

<div class="grey-bg uk-margin-large-top">	
<div class="uk-container uk-container-large">	
	
	<div class="uk-child-width-1-3@m service-grid" uk-grid>

        <div>
			<div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>
				<div class="uk-width-auto">
					<svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M14.5234 16.5138H35.3659C35.5649 16.5138 35.7556 16.4347 35.8963 16.2941C36.0369 16.1534 36.1159 15.9627 36.1159 15.7638V9.78751C36.1151 9.15037 35.8615 8.5396 35.4109 8.08919C34.9602 7.63879 34.3493 7.38554 33.7122 7.38501H16.1772C15.5401 7.38557 14.9292 7.63883 14.4785 8.08923C14.0279 8.53963 13.7743 9.15038 13.7734 9.78751V15.7638C13.7734 15.9627 13.8525 16.1534 13.9931 16.2941C14.1338 16.4347 14.3245 16.5138 14.5234 16.5138ZM15.2734 9.78751C15.2739 9.54807 15.3693 9.31857 15.5387 9.14938C15.7081 8.98019 15.9377 8.88511 16.1772 8.88501H33.7122C33.9516 8.88511 34.1813 8.98019 34.3507 9.14938C34.5201 9.31857 34.6155 9.54807 34.6159 9.78751V15.0138H15.2734V9.78751Z" fill="#0F52BA"></path><path d="M14.1836 23.9963C13.9847 23.9963 13.7939 24.0754 13.6533 24.216C13.5126 24.3567 13.4336 24.5474 13.4336 24.7463V25.7251C13.4336 25.924 13.5126 26.1148 13.6533 26.2554C13.7939 26.3961 13.9847 26.4751 14.1836 26.4751C14.3825 26.4751 14.5733 26.3961 14.7139 26.2554C14.8546 26.1148 14.9336 25.924 14.9336 25.7251V24.7463C14.9336 24.5474 14.8546 24.3567 14.7139 24.216C14.5733 24.0754 14.3825 23.9963 14.1836 23.9963Z" fill="#0F52BA"></path><path d="M14.1836 27.2139C13.9847 27.2139 13.7939 27.2929 13.6533 27.4335C13.5126 27.5742 13.4336 27.765 13.4336 27.9639V42.6551C13.4336 42.854 13.5126 43.0448 13.6533 43.1854C13.7939 43.3261 13.9847 43.4051 14.1836 43.4051C14.3825 43.4051 14.5733 43.3261 14.7139 43.1854C14.8546 43.0448 14.9336 42.854 14.9336 42.6551V27.9639C14.9336 27.765 14.8546 27.5742 14.7139 27.4335C14.5733 27.2929 14.3825 27.2139 14.1836 27.2139Z" fill="#0F52BA"></path><path d="M26.0421 23.8625C26.0421 24.0615 26.1211 24.2522 26.2618 24.3929C26.4024 24.5335 26.5932 24.6125 26.7921 24.6125H43.7017C43.9768 24.6129 44.2405 24.7223 44.435 24.9168C44.6295 25.1113 44.7389 25.375 44.7392 25.65V50.9363C44.7389 51.2114 44.6295 51.4751 44.435 51.6696C44.2405 51.8641 43.9768 51.9735 43.7017 51.9738H20.018C19.7429 51.9735 19.4792 51.8641 19.2847 51.6696C19.0902 51.4751 18.9808 51.2114 18.9805 50.9363V25.65C18.9808 25.375 19.0902 25.1113 19.2847 24.9168C19.4792 24.7223 19.7429 24.6129 20.018 24.6125H23.0421C23.241 24.6125 23.4318 24.5335 23.5724 24.3929C23.7131 24.2522 23.7921 24.0615 23.7921 23.8625C23.7921 23.6636 23.7131 23.4729 23.5724 23.3322C23.4318 23.1916 23.241 23.1125 23.0421 23.1125H20.018C19.3452 23.1133 18.7002 23.3809 18.2245 23.8566C17.7488 24.3323 17.4812 24.9773 17.4805 25.65V50.9363C17.4812 51.6091 17.7488 52.2541 18.2245 52.7298C18.7002 53.2055 19.3452 53.4731 20.018 53.4738H43.7017C44.3745 53.4731 45.0195 53.2055 45.4952 52.7298C45.9709 52.2541 46.2385 51.6091 46.2392 50.9363V25.65C46.2385 24.9773 45.9709 24.3323 45.4952 23.8566C45.0195 23.3809 44.3745 23.1133 43.7017 23.1125H26.7921C26.5932 23.1125 26.4024 23.1916 26.2618 23.3322C26.1211 23.4729 26.0421 23.6636 26.0421 23.8625Z" fill="#0F52BA"></path><path d="M31.1723 48.6656C32.4423 48.6665 33.6901 48.3319 34.7892 47.6956C35.8884 47.0593 36.7999 46.144 37.4316 45.0421C38.0633 43.9403 38.3927 42.6912 38.3864 41.4211C38.3801 40.1511 38.0384 38.9053 37.3959 37.8097L31.8196 28.2885C31.7535 28.1755 31.659 28.0819 31.5454 28.0168C31.4319 27.9517 31.3033 27.9175 31.1725 27.9175C31.0416 27.9175 30.913 27.9517 30.7995 28.0168C30.6859 28.0819 30.5914 28.1755 30.5253 28.2885L24.9478 37.8097C24.3051 38.9054 23.9634 40.1513 23.9571 41.4215C23.9509 42.6917 24.2803 43.941 24.9122 45.0429C25.544 46.1448 26.4558 47.0602 27.5552 47.6964C28.6546 48.3325 29.9026 48.667 31.1728 48.6657L31.1723 48.6656ZM26.242 38.5677L31.1723 30.1513L36.1018 38.568C36.7408 39.6584 37.0001 40.93 36.8391 42.1837C36.6781 43.4373 36.1059 44.6021 35.2121 45.4957C34.2297 46.4779 32.9232 47.0686 31.5368 47.1572C30.1504 47.2458 28.7793 46.8263 27.6798 45.9771C26.5804 45.1279 25.828 43.9073 25.5634 42.5435C25.2988 41.1798 25.5401 39.7663 26.2421 38.5676L26.242 38.5677Z" fill="#0F52BA"></path><path d="M32.346 44.7999C32.4288 44.7999 32.5111 44.7861 32.5895 44.7591C32.8967 44.6533 33.1912 44.5134 33.4672 44.342C33.7497 44.1654 34.0112 43.9574 34.2469 43.722C34.8531 43.1178 35.2663 42.3472 35.4344 41.5079C35.4658 41.3162 35.4216 41.1198 35.3112 40.96C35.2007 40.8002 35.0325 40.6895 34.8421 40.6512C34.6516 40.6129 34.4538 40.65 34.2901 40.7547C34.1265 40.8594 34.0098 41.0235 33.9647 41.2124C33.8547 41.7618 33.5841 42.2662 33.1871 42.6615C33.0322 42.8163 32.8602 42.9531 32.6746 43.0693C32.4946 43.181 32.3027 43.2722 32.1024 43.3412C31.9349 43.3991 31.7934 43.5145 31.7029 43.6668C31.6124 43.8192 31.5787 43.9987 31.6079 44.1734C31.6371 44.3482 31.7272 44.507 31.8623 44.6217C31.9974 44.7364 32.1688 44.7995 32.346 44.7999Z" fill="#0F52BA"></path><path d="M55.4659 13.0865L44.7434 7.88021C44.6537 7.83664 44.5561 7.81141 44.4565 7.806C44.3569 7.8006 44.2572 7.81512 44.1632 7.84873C44.0693 7.88234 43.983 7.93435 43.9094 8.00172C43.8358 8.06909 43.7764 8.15047 43.7347 8.24109L42.2383 11.4891L41.6275 11.1741V8.28121C41.6255 6.6217 40.9653 5.03077 39.7917 3.85743C38.6181 2.6841 37.027 2.02418 35.3675 2.02246H14.3733C12.7138 2.02418 11.1227 2.6841 9.94913 3.85743C8.77556 5.03077 8.11533 6.6217 8.11328 8.28121V55.7187C8.11533 57.3782 8.77556 58.9692 9.94913 60.1425C11.1227 61.3158 12.7138 61.9757 14.3733 61.9775H49.3483C51.0076 61.9756 52.5985 61.3156 53.7718 60.1422C54.9451 58.9689 55.6052 57.3781 55.607 55.7187V18.8437C55.607 18.706 55.5691 18.571 55.4975 18.4535C55.4259 18.3359 55.3233 18.2403 55.2009 18.1772L54.2275 17.6751L55.8242 14.0645C55.9027 13.8868 55.9093 13.6856 55.8425 13.5031C55.7757 13.3207 55.6407 13.1713 55.4659 13.0865ZM54.107 55.7187C54.1056 56.9804 53.6037 58.1899 52.7116 59.0821C51.8195 59.9742 50.6099 60.476 49.3483 60.4775H14.3733C13.1115 60.4762 11.9016 59.9745 11.0093 59.0824C10.1169 58.1902 9.61487 56.9805 9.61328 55.7187V8.28121C9.61487 7.01938 10.1169 5.80971 11.0093 4.91758C11.9016 4.02545 13.1115 3.52372 14.3733 3.52246H35.367C36.6289 3.52372 37.8387 4.02545 38.731 4.91758C39.6234 5.80971 40.1255 7.01938 40.127 8.28121V11.6312C40.1271 11.7689 40.165 11.9039 40.2366 12.0215C40.3083 12.139 40.4109 12.2346 40.5333 12.2977L54.107 19.3007V55.7187ZM52.8923 16.9861L43.572 12.1773L44.7767 9.56384L54.1597 14.1197L52.8923 16.9861Z" fill="#0F52BA"></path></svg>
				</div>
				<div class="uk-width-expand">
					<span class="numbers blue"><strong>01</strong></span><br>
					<h4 class="black uk-margin-remove">Brake Services</h4>
					
				</div>
			</div>
            
            <hr class="blue-hr">
			<p>We service a wide range of brake components. If your brakes are making strange noises, we can identify the cause and provide full repairs or replacements as needed. Contact us now to learn why your brakes are squeaky — they may just need some lubrication, but it's better to be safe than sorry.</p>
			<a href="<?= home_url(); ?>/brake-repair/" class="blue"><strong>MORE <i class="fa-sharp-duotone fa-regular fa-arrow-right-long"></i></strong></a>
        </div>
		
		<div>
			<div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>
				<div class="uk-width-auto">
					<svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M62.6362 17.1832L51.4305 5.97748C49.7999 4.34659 47.2687 4.15634 45.4123 5.5251L39.359 9.98838C39.1393 10.1504 39.0012 10.4003 38.9807 10.6725C38.9602 10.9448 39.0595 11.2124 39.2525 11.4055L40.7113 12.8643L34.3026 19.273H29.6972L23.2882 12.8639L24.7472 11.4048C24.9403 11.2116 25.0394 10.944 25.019 10.6718C24.9985 10.3995 24.8603 10.1496 24.6405 9.98763L18.5875 5.52535C16.7319 4.15621 14.2008 4.34646 12.5694 5.97798L10.7951 7.75249C10.4291 8.11849 10.4291 8.712 10.7951 9.078C11.1611 9.444 11.7546 9.444 12.1206 9.078L13.8951 7.30349C14.8657 6.33285 16.371 6.21948 17.475 7.03399L19.489 8.51875L3.90463 24.103L2.41987 22.0896C1.60598 20.9842 1.71924 19.478 2.68912 18.5081L9.46992 11.7274C9.83593 11.3614 9.83593 10.768 9.46992 10.4019C9.10404 10.0359 8.51054 10.0359 8.14441 10.4019L1.36361 17.1826C-0.26653 18.8127 -0.457157 21.3438 0.910854 23.2015L5.37476 29.2549C5.53677 29.4747 5.78664 29.6128 6.05889 29.6333C6.08239 29.635 6.10577 29.6359 6.12915 29.6359C6.37665 29.6359 6.6154 29.5378 6.7919 29.3614L8.25079 27.9024L9.33917 28.9908C7.03965 30.9704 5.69427 33.8601 5.69427 36.9205C5.69427 41.9459 9.28092 46.2373 14.1468 47.1878C14.676 49.9918 16.6731 52.2828 19.3075 53.2278V56.5945C19.3075 58.1341 20.5595 59.3866 22.0985 59.3866C23.3094 59.3866 24.3424 58.6116 24.7284 57.5318H26.0703C26.4562 58.6116 27.4886 59.3866 28.6989 59.3866C29.9098 59.3866 30.9428 58.6116 31.3288 57.5318H32.6711C33.057 58.6114 34.0897 59.3863 35.3004 59.3863C36.511 59.3863 37.5436 58.6114 37.9295 57.5318H39.2719C39.6578 58.6114 40.6905 59.3863 41.901 59.3863C43.4403 59.3863 44.6926 58.134 44.6926 56.5947V49.2262C46.1626 49.0232 47.4838 48.3504 48.5004 47.3641C50.374 47.2466 52.1744 46.629 53.7291 45.5673C54.1566 45.2753 54.2665 44.6922 53.9745 44.2647C53.6828 43.8373 53.0994 43.7273 52.672 44.0193C51.8485 44.5817 50.9407 44.9909 49.9874 45.2372C50.2882 44.5617 50.4822 43.8291 50.5482 43.06C52.9685 41.9963 54.5535 39.6066 54.5535 36.9206C54.5535 34.8398 53.5979 32.9138 51.998 31.6536L53.331 30.3205C55.2849 31.9471 56.431 34.3612 56.431 36.9203C56.431 38.5956 55.9462 40.2197 55.0289 41.6173C54.7449 42.05 54.8654 42.631 55.2982 42.9151C55.4568 43.0193 55.6352 43.0689 55.8117 43.0689C56.1168 43.0689 56.416 42.92 56.596 42.6459C57.7144 40.942 58.3056 38.9621 58.3056 36.9205C58.3056 33.8594 56.96 30.97 54.6604 28.9914L55.7494 27.9024L57.2083 29.3613C57.3847 29.5377 57.6234 29.6358 57.8709 29.6358C57.8943 29.6358 57.9177 29.6349 57.9412 29.6332C58.2134 29.6127 58.4633 29.4745 58.6253 29.2548L63.0886 23.2016C64.4574 21.345 64.2671 18.814 62.6362 17.1832ZM47.5248 25.84C47.5248 25.6048 47.6165 25.3835 47.7828 25.2171L50.4236 22.5764L51.6693 23.822L49.0285 26.4628C48.8621 26.6291 48.641 26.7208 48.4057 26.7208C48.1705 26.7208 47.9492 26.6291 47.7828 26.4628C47.6165 26.2965 47.5248 26.0753 47.5248 25.84ZM45.2046 17.3574L46.0373 18.1902L43.3966 20.831C43.2302 20.9973 43.0091 21.089 42.7737 21.089C42.5384 21.089 42.3173 20.9973 42.1508 20.831C41.8074 20.4876 41.8074 19.9287 42.1508 19.5853L44.7916 16.9446L45.2046 17.3574ZM42.0369 14.1898L43.4662 15.6191L40.8254 18.2598C39.7512 19.3341 39.7512 21.0821 40.8254 22.1564C41.3458 22.6767 42.0378 22.9634 42.7737 22.9634C43.5097 22.9634 44.2016 22.6767 44.7219 22.1564L47.3627 19.5156L49.0981 21.251L46.4573 23.8917C45.937 24.4121 45.6503 25.1041 45.6503 25.84C45.6503 26.5759 45.937 27.2679 46.4573 27.7883C46.9777 28.3087 47.6696 28.5953 48.4056 28.5953C49.1416 28.5953 49.8335 28.3087 50.3539 27.7883L52.9946 25.1475L54.4239 26.5768L48.4035 32.5973L36.0164 20.2103L42.0369 14.1898ZM38.0918 49.2927H39.1095V55.6572H38.0918V49.2927ZM31.6581 47.4182L36.9414 42.2315C36.9386 42.3115 36.9353 42.3915 36.9353 42.4721C36.9353 44.4179 37.7556 46.1745 39.067 47.4182H31.6581ZM24.8907 53.1513C25.2425 53.0142 25.5823 52.8533 25.9081 52.6697V55.6572H24.8907V53.1513ZM31.4912 49.2927H32.5089V55.6572H31.4912V49.2927ZM29.9533 46.4649C29.9772 46.214 29.9906 45.9602 29.9906 45.7032C29.9906 41.2964 26.4053 37.7111 21.9985 37.7111C21.8259 37.7111 21.655 37.7185 21.485 37.7294L26.7104 32.6197C26.9059 35.368 29.2028 37.5447 32 37.5447C34.925 37.5447 37.3046 35.1651 37.3046 32.2401C37.3046 32.1148 37.2988 31.9911 37.2901 31.8681L42.6659 35.7402C41.2224 35.973 39.9288 36.6593 38.9378 37.6493L38.9389 37.6436L29.9533 46.4649ZM13.3398 32.9916L14.7745 34.4262L16.5317 39.8812C15.9821 40.3977 15.5052 40.9903 15.1186 41.6429C12.9466 41.1606 11.3202 39.1927 11.3202 36.9206C11.3203 35.3466 12.0798 33.8946 13.3398 32.9916ZM32 28.8099C33.8914 28.8099 35.4301 30.3487 35.4301 32.2401C35.4301 34.1314 33.8914 35.6702 32 35.6702C30.1086 35.6702 28.5698 34.1314 28.5698 32.2401C28.5698 30.3487 30.1086 28.8099 32 28.8099ZM46.6465 36.2972C46.6465 36.2972 35.3156 28.0989 35.1836 27.9995C34.2962 27.3316 33.1935 26.9354 32 26.9354C30.6197 26.9354 29.3612 27.4658 28.4166 28.3328L18.0465 38.4699L16.6646 34.1802L29.6973 21.1475H34.3027L47.3353 34.1801L46.6528 36.3C46.6507 36.2991 46.6486 36.2982 46.6465 36.2972ZM13.5765 22.5765L16.2172 25.2173C16.3836 25.3836 16.4752 25.6048 16.4752 25.84C16.4752 26.0753 16.3836 26.2965 16.2172 26.4628C16.0508 26.6291 15.8297 26.7208 15.5943 26.7208C15.3591 26.7208 15.138 26.6291 14.9716 26.4628L12.3308 23.822L13.5765 22.5765ZM6.23677 27.2655L5.02976 25.6288L21.0149 9.64363L22.6513 10.8499L6.23677 27.2655ZM11.0054 25.1476L13.6461 27.7883C14.1665 28.3087 14.8583 28.5953 15.5943 28.5953C16.3304 28.5953 17.0222 28.3087 17.5426 27.7883C18.063 27.2679 18.3496 26.5759 18.3496 25.84C18.3496 25.1041 18.063 24.4121 17.5426 23.8917L14.9018 21.251L14.9236 21.2292L16.6372 19.5156L19.278 22.1564C19.7984 22.6767 20.4903 22.9634 21.2263 22.9634C21.9623 22.9634 22.6542 22.6767 23.1745 22.1564C24.2488 21.0821 24.2488 19.3341 23.1745 18.2598L20.5338 15.6191L21.963 14.1898L27.9836 20.2103L15.5965 32.5973L9.57617 26.577L11.0054 25.1476ZM19.2084 16.9446L21.8491 19.5853C22.1925 19.9287 22.1925 20.4876 21.8491 20.831C21.6828 20.9973 21.4615 21.089 21.2263 21.089C20.991 21.089 20.7698 20.9973 20.6034 20.831L17.9627 18.1902L19.2084 16.9446ZM7.56878 36.9205C7.56878 34.3619 8.71479 31.9476 10.6684 30.32L12.0017 31.6533C10.4016 32.9137 9.44567 34.8397 9.44567 36.9205C9.44567 38.6029 10.0736 40.2132 11.2137 41.455C12.0692 42.3868 13.1556 43.0495 14.3506 43.3838C14.1705 43.9764 14.0576 44.5978 14.0207 45.2394C10.2763 44.2792 7.56878 40.8769 7.56878 36.9205ZM15.881 45.7032C15.881 42.33 18.6254 39.5856 21.9985 39.5856C25.3717 39.5856 28.1161 42.3299 28.1161 45.7032C28.1161 49.0764 25.3717 51.8207 21.9985 51.8207C18.6254 51.8207 15.881 49.0764 15.881 45.7032ZM22.0985 57.5121C21.5933 57.5121 21.182 57.1005 21.182 56.5945V53.6539C21.4505 53.6812 21.7228 53.6952 21.9984 53.6952C22.3434 53.6952 22.6825 53.6709 23.0162 53.6282V56.5945C23.0162 57.1005 22.6045 57.5121 22.0985 57.5121ZM28.6989 57.5121C28.1937 57.5121 27.7826 57.1005 27.7826 56.5945V51.2228L29.6167 49.4222V56.5944C29.6167 57.1005 29.2051 57.5121 28.6989 57.5121ZM35.3004 57.5118C34.7947 57.5118 34.3834 57.1004 34.3834 56.5947V49.2927H36.2173V56.5947C36.2173 57.1004 35.806 57.5118 35.3004 57.5118ZM41.901 57.5118C41.3954 57.5118 40.9842 57.1004 40.9842 56.5947V49.2927H42.8181V56.5947C42.8181 57.1004 42.4067 57.5118 41.901 57.5118ZM43.7553 47.4177C41.0284 47.4177 38.8098 45.1992 38.8098 42.4721C38.8098 39.7452 41.0283 37.5266 43.7553 37.5266C46.4822 37.5266 48.7009 39.7451 48.7009 42.4721C48.7009 45.1992 46.4822 47.4177 43.7553 47.4177ZM52.679 36.9206C52.679 38.6144 51.8044 40.145 50.4169 41.0149C50.1034 39.5807 49.3377 38.3142 48.2767 37.3726L49.2252 34.4265L50.6599 32.9918C51.9196 33.8944 52.679 35.3465 52.679 36.9206ZM57.7632 27.2651L41.3485 10.8505L42.9852 9.64376L58.9699 25.6285L57.7632 27.2651ZM61.5798 22.0889L60.0949 24.1026L44.5109 8.51862L46.5247 7.03374C47.6292 6.21935 49.1349 6.33261 50.105 7.30286L61.3107 18.5086C62.281 19.4788 62.3941 20.9846 61.5798 22.0889Z" fill="#0F52BA"></path><path d="M24.8296 45.7031C24.8296 44.1433 23.5606 42.8743 22.0007 42.8743C20.4409 42.8743 19.1719 44.1433 19.1719 45.7031C19.1719 47.263 20.4409 48.532 22.0007 48.532C23.5606 48.532 24.8296 47.263 24.8296 45.7031ZM21.0464 45.7031C21.0464 45.1769 21.4745 44.7488 22.0007 44.7488C22.527 44.7488 22.9551 45.1769 22.9551 45.7031C22.9551 46.2294 22.527 46.6575 22.0007 46.6575C21.4745 46.6575 21.0464 46.2294 21.0464 45.7031Z" fill="#0F52BA"></path><path d="M43.7547 39.6431C42.1948 39.6431 40.9258 40.9121 40.9258 42.4719C40.9258 44.0318 42.1948 45.3008 43.7547 45.3008C45.3145 45.3008 46.5835 44.0318 46.5835 42.4719C46.5835 40.9121 45.3145 39.6431 43.7547 39.6431ZM43.7547 43.4263C43.2284 43.4263 42.8003 42.9982 42.8003 42.4719C42.8003 41.9457 43.2284 41.5176 43.7547 41.5176C44.2809 41.5176 44.709 41.9457 44.709 42.4719C44.709 42.9982 44.2809 43.4263 43.7547 43.4263Z" fill="#0F52BA"></path></svg>
				</div>
				<div class="uk-width-expand">
					<span class="numbers blue"><strong>02</strong></span><br>
					<h4 class="black uk-margin-remove">Engine Diagnosis</h4>
					
				</div>
			</div>
            
            <hr class="blue-hr">
			<p>We offer a complete, accurate diagnosis of any engine problems. The cost for this service varies — it could cost nothing, though a more complex diagnosis may require a fee. Our shop offers a warranty on our diagnosis of three years or 36,000 miles.</p>
			<a href="<?= home_url(); ?>/engine-diagnostics/" class="blue"><strong>MORE <i class="fa-sharp-duotone fa-regular fa-arrow-right-long"></i></strong></a>
        </div>
		
		<div>
			<div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>
				<div class="uk-width-auto">
					<svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M31.9973 52.3921C29.641 52.3921 27.7305 54.3026 27.7305 56.659C27.7305 59.0153 29.641 60.9258 31.9973 60.9258C34.3542 60.9258 36.2642 59.0153 36.2642 56.659C36.2642 54.3026 34.3542 52.3921 31.9973 52.3921ZM31.9973 58.7924C30.8192 58.7924 29.8639 57.8371 29.8639 56.659C29.8639 55.4808 30.8192 54.5255 31.9973 54.5255C33.1755 54.5255 34.1308 55.4808 34.1308 56.659C34.1308 57.8371 33.1755 58.7924 31.9973 58.7924Z" fill="#0F52BA"></path><path d="M53.3339 38.5247C56.869 38.5247 59.7342 35.6595 59.7342 32.1244C59.7342 28.5899 56.869 25.7241 53.3339 25.7241C49.7994 25.7241 46.9336 28.5899 46.9336 32.1244C46.9372 35.6579 49.8009 38.5211 53.3339 38.5247ZM53.3339 27.8576C55.6908 27.8576 57.6008 29.7681 57.6008 32.1244C57.6008 34.4808 55.6908 36.3913 53.3339 36.3913C50.9775 36.3913 49.067 34.4808 49.067 32.1244C49.067 29.7681 50.9775 27.8576 53.3339 27.8576Z" fill="#0F52BA"></path><path d="M63.9999 32.1244C63.9936 26.2356 59.2215 21.464 53.3327 21.4572C53.1311 21.4572 52.9358 21.4765 52.7374 21.4869L32.3187 9.57751C28.7899 2.49801 20.8572 -1.22613 13.1569 0.581771C5.456 2.38967 0.00938756 9.25509 1.21196e-05 17.1648C-0.00936332 25.0746 5.42162 31.953 13.1178 33.7792L24.8069 54.6791C24.0438 57.4386 24.9272 60.3913 27.0804 62.2779C29.2342 64.1644 32.277 64.6525 34.9126 63.5332C37.5476 62.4138 39.3097 59.8856 39.4472 57.0261L54.3812 42.7384C59.8367 42.1936 63.9931 37.6069 63.9999 32.1244ZM29.5014 49.6304L20.7374 33.8495C28.2414 32.1812 33.7063 25.7053 34.0891 18.0279L45.6334 24.7642C43.4885 26.9945 42.4223 30.0483 42.713 33.1291C43.0036 36.2095 44.6219 39.0101 47.146 40.7998L36.6538 50.8336C34.6428 49.2096 31.9296 48.7538 29.4983 49.6304H29.5014ZM49.083 41.903C49.8352 42.229 50.6227 42.4671 51.43 42.6113L39.1123 54.3942C38.8826 53.6806 38.5466 53.0061 38.1164 52.392L49.083 41.903ZM61.8665 32.1244C61.8665 36.8376 58.046 40.6581 53.3327 40.6581C48.62 40.6581 44.799 36.8376 44.799 32.1244C44.799 27.4112 48.62 23.5907 53.3327 23.5907C58.0439 23.5959 61.8612 27.4138 61.8665 32.1244ZM49.6164 22.139C48.8184 22.4328 48.0585 22.8214 47.3528 23.2964L34.0474 15.5351C33.9526 14.5944 33.7782 13.6636 33.5261 12.7527L49.6164 22.139ZM2.13032 17.1904C2.13032 8.94258 8.81657 2.25633 17.0644 2.25633C25.3121 2.25633 31.9984 8.94258 31.9984 17.1904C31.9984 25.4381 25.3121 32.1244 17.0644 32.1244C8.82022 32.1155 2.13917 25.4345 2.13032 17.1904ZM15.7961 34.1938C16.2164 34.225 16.6367 34.2578 17.0644 34.2578C17.5435 34.2578 18.0149 34.225 18.4842 34.1865L27.6154 50.6279C26.9674 51.0987 26.3997 51.6706 25.933 52.3217L15.7961 34.1938ZM31.9984 61.9925C29.0529 61.9925 26.6648 59.6048 26.6648 56.6589C26.6648 53.7134 29.0529 51.3253 31.9984 51.3253C34.9444 51.3253 37.332 53.7134 37.332 56.6589C37.3283 59.6033 34.9428 61.9888 31.9984 61.9925Z" fill="#0F52BA"></path><path d="M29.8629 17.1905C29.8629 10.1209 24.1319 4.38989 17.0623 4.38989C9.99272 4.38989 4.26172 10.1209 4.26172 17.1905C4.26172 24.2601 9.99272 29.9911 17.0623 29.9911C24.1288 29.9833 29.8556 24.257 29.8629 17.1905ZM6.39515 17.1905C6.39515 11.2991 11.1709 6.52333 17.0623 6.52333C22.9537 6.52333 27.7295 11.2991 27.7295 17.1905C27.7295 23.0819 22.9537 27.8577 17.0623 27.8577C11.174 27.8514 6.40192 23.0793 6.39515 17.1905Z" fill="#0F52BA"></path><path d="M20.2636 17.1904C20.2636 15.4231 18.8307 13.9902 17.0634 13.9902C15.2962 13.9902 13.8633 15.4231 13.8633 17.1904C13.8633 18.9576 15.2962 20.3905 17.0634 20.3905C18.8307 20.3905 20.2636 18.9576 20.2636 17.1904ZM17.0634 18.2571C16.4743 18.2571 15.9967 17.7795 15.9967 17.1904C15.9967 16.6013 16.4743 16.1237 17.0634 16.1237C17.6525 16.1237 18.1302 16.6013 18.1302 17.1904C18.1302 17.7795 17.6525 18.2571 17.0634 18.2571Z" fill="#0F52BA"></path><path d="M20.2636 10.7902C20.2636 9.02297 18.8307 7.59009 17.0634 7.59009C15.2962 7.59009 13.8633 9.02297 13.8633 10.7902C13.8633 12.5575 15.2962 13.9904 17.0634 13.9904C18.8307 13.9904 20.2636 12.5575 20.2636 10.7902ZM17.0634 11.857C16.4743 11.857 15.9967 11.3793 15.9967 10.7902C15.9967 10.2011 16.4743 9.72352 17.0634 9.72352C17.6525 9.72352 18.1302 10.2011 18.1302 10.7902C18.1302 11.3793 17.6525 11.857 17.0634 11.857Z" fill="#0F52BA"></path><path d="M10.665 13.9902C8.89772 13.9902 7.46484 15.4231 7.46484 17.1904C7.46484 18.9576 8.89772 20.3905 10.665 20.3905C12.4323 20.3905 13.8651 18.9576 13.8651 17.1904C13.8651 15.4231 12.4323 13.9902 10.665 13.9902ZM10.665 18.2571C10.0759 18.2571 9.59828 17.7795 9.59828 17.1904C9.59828 16.6013 10.0759 16.1237 10.665 16.1237C11.2541 16.1237 11.7317 16.6013 11.7317 17.1904C11.7317 17.7795 11.2541 18.2571 10.665 18.2571Z" fill="#0F52BA"></path><path d="M20.2636 23.5908C20.2636 21.8235 18.8307 20.3906 17.0634 20.3906C15.2962 20.3906 13.8633 21.8235 13.8633 23.5908C13.8633 25.358 15.2962 26.7909 17.0634 26.7909C18.8307 26.7909 20.2636 25.358 20.2636 23.5908ZM15.9967 23.5908C15.9967 23.0017 16.4743 22.5241 17.0634 22.5241C17.6525 22.5241 18.1302 23.0017 18.1302 23.5908C18.1302 24.1799 17.6525 24.6575 17.0634 24.6575C16.4743 24.6575 15.9967 24.1799 15.9967 23.5908Z" fill="#0F52BA"></path><path d="M23.4658 20.3905C25.233 20.3905 26.6659 18.9576 26.6659 17.1904C26.6659 15.4231 25.233 13.9902 23.4658 13.9902C21.6985 13.9902 20.2656 15.4231 20.2656 17.1904C20.2656 18.9576 21.6985 20.3905 23.4658 20.3905ZM23.4658 16.1237C24.0549 16.1237 24.5325 16.6013 24.5325 17.1904C24.5325 17.7795 24.0549 18.2571 23.4658 18.2571C22.8767 18.2571 22.3991 17.7795 22.3991 17.1904C22.3991 16.6013 22.8767 16.1237 23.4658 16.1237Z" fill="#0F52BA"></path><path d="M37.333 10.7901H39.4664C39.4628 7.84624 37.0772 5.46019 34.1328 5.45654V7.58998C35.9001 7.58998 37.333 9.02286 37.333 10.7901Z" fill="#0F52BA"></path><path d="M41.5998 10.7901H43.7333C43.7276 5.49042 39.4326 1.19543 34.1328 1.1897V3.32313C38.2549 3.32834 41.5946 6.6686 41.5998 10.7901Z" fill="#0F52BA"></path><path d="M9.59828 34.2578H7.46484C7.46849 37.2022 9.85454 39.5877 12.7984 39.5914V37.4579C11.0312 37.4579 9.59828 36.0251 9.59828 34.2578Z" fill="#0F52BA"></path><path d="M5.32875 34.2578H3.19531C3.20156 39.5575 7.49603 43.8525 12.7958 43.8583V41.7248C8.67421 41.7196 5.33395 38.3794 5.32875 34.2578Z" fill="#0F52BA"></path></svg>
				</div>
				<div class="uk-width-expand">
					<span class="numbers blue"><strong>03</strong></span><br>
					<h4 class="black uk-margin-remove">Transmission Services</h4>
					
				</div>
			</div>
            
            <hr class="blue-hr">
			<p>We check the transmission to make sure everything is running and working properly. We make sure it's shifting properly. It's a lot like replacing the engine oil - we check the transmission fluid, as well. Transmission fluid helps the transmission last longer. Reach out to us now to learn more.</p>
			<a href="<?= home_url(); ?>/transmission-repair/" class="blue"><strong>MORE <i class="fa-sharp-duotone fa-regular fa-arrow-right-long"></i></strong></a>
        </div>
		
		<div>
			<div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>
				<div class="uk-width-auto">
					<svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M45.4993 45.4983H45.3514C44.6613 45.4983 44.1016 46.0578 44.1016 46.7482C44.1016 47.4384 44.6612 47.998 45.3514 47.998H45.4993C46.1894 47.998 46.7492 47.4385 46.7492 46.7482C46.7492 46.0578 46.1896 45.4983 45.4993 45.4983Z" fill="#0F52BA"></path><path d="M62.7501 35.4997H47.2459V32.0625L52.3331 33.4256C52.4415 33.4546 52.5503 33.4685 52.6574 33.4685C53.2091 33.4685 53.7143 33.1001 53.8639 32.5418C54.0426 31.8751 53.6469 31.1897 52.9801 31.0111L33.664 25.8353C32.9969 25.6566 32.312 26.0525 32.1334 26.7191C31.9546 27.3858 32.3504 28.0712 33.0171 28.2498L38.7513 29.7862V35.4996H29.4963V35.2496C29.4963 34.5593 28.9366 33.9997 28.2464 33.9997H24.4969V24.501C24.4969 21.7443 22.2541 19.5016 19.4975 19.5016H4.99937C2.24275 19.5016 0 21.7443 0 24.501V58.9965C0 61.7531 2.24275 63.9958 4.99937 63.9958H19.4975C22.2541 63.9958 24.4969 61.7531 24.4969 58.9965V49.4977H28.2464C28.9365 49.4977 29.4963 48.9382 29.4963 48.2478V47.9978H39.0366C39.7267 47.9978 40.2865 47.4383 40.2865 46.748C40.2865 46.0577 39.7269 45.4981 39.0366 45.4981H29.4963V37.9991H61.5004V45.4981H52.6566C51.9665 45.4981 51.4067 46.0576 51.4067 46.748C51.4067 47.4382 51.9664 47.9978 52.6566 47.9978H62.7503C63.4404 47.9978 64.0001 47.4383 64.0001 46.748V36.7492C64 36.0592 63.4405 35.4997 62.7501 35.4997ZM4.99937 61.4963C3.621 61.4963 2.49975 60.375 2.49975 58.9967V58.0356L5.9605 61.4963H4.99937ZM21.9971 58.9967C21.9971 60.3751 20.8757 61.4963 19.4975 61.4963H18.5364L21.9971 58.0356V58.9967ZM21.9971 29.6801C21.8071 29.7378 21.6281 29.8415 21.478 29.9917L15.4163 36.0535C14.9283 36.5415 14.9283 37.333 15.4163 37.8211C15.6604 38.0652 15.9801 38.1872 16.3 38.1872C16.6199 38.1872 16.9396 38.0652 17.1838 37.8211L21.9971 33.0076V35.2498V38.0227C21.8071 38.0805 21.6281 38.1841 21.478 38.3343L15.4163 44.3961C14.9283 44.8841 14.9283 45.6756 15.4163 46.1637C15.6604 46.4078 15.9801 46.5298 16.3 46.5298C16.6199 46.5298 16.9396 46.4078 17.1838 46.1637L21.9971 41.3503V46.3656C21.8071 46.4233 21.6281 46.527 21.478 46.6772L15.4163 52.739C14.9283 53.227 14.9283 54.0185 15.4163 54.5066C15.6604 54.7507 15.9801 54.8727 16.3 54.8727C16.6199 54.8727 16.9396 54.7507 17.1838 54.5066L21.9971 49.6931V54.7083C21.8071 54.7661 21.6281 54.8697 21.478 55.02L15.4163 61.0817C15.2937 61.2042 15.2021 61.3458 15.1411 61.4968H9.35575C9.29475 61.3457 9.20312 61.2042 9.08062 61.0817L3.01887 55.02C2.86862 54.8697 2.6895 54.7662 2.49962 54.7083V49.6931L7.313 54.5065C7.55713 54.7506 7.87687 54.8726 8.19675 54.8726C8.51662 54.8726 8.83637 54.7506 9.0805 54.5065C9.5685 54.0183 9.5685 53.227 9.0805 52.7388L3.01875 46.6771C2.8685 46.5268 2.68937 46.4233 2.4995 46.3655V41.3501L7.31287 46.1635C7.557 46.4076 7.87675 46.5296 8.19662 46.5296C8.5165 46.5296 8.83625 46.4076 9.08037 46.1635C9.56837 45.6753 9.56837 44.884 9.08037 44.3958L3.01863 38.3341C2.86838 38.1838 2.68925 38.0803 2.49938 38.0225V33.0072L7.31275 37.8206C7.55687 38.0647 7.87663 38.1867 8.1965 38.1867C8.51637 38.1867 8.83612 38.0647 9.08025 37.8206C9.56825 37.3325 9.56825 36.5411 9.08025 36.053L3.019 29.9913C2.86875 29.8411 2.68962 29.7376 2.49975 29.6797V24.6645L7.31313 29.4778C7.55725 29.722 7.877 29.844 8.19687 29.844C8.51675 29.844 8.8365 29.722 9.08062 29.4778C9.56862 28.9898 9.56862 28.1983 9.08062 27.7102L3.72475 22.3548C4.0985 22.132 4.53337 22.0016 4.99937 22.0016H19.4975V22.0015C19.9634 22.0015 20.3984 22.132 20.7721 22.3547L15.4164 27.7105C14.9284 28.1985 14.9284 28.99 15.4164 29.4781C15.6605 29.7222 15.9803 29.8442 16.3001 29.8442C16.62 29.8442 16.9397 29.7222 17.1839 29.4781L21.9972 24.6648V29.6801H21.9971ZM26.9965 36.7496V46.7483V46.9983H24.4969V36.4997H26.9965V36.7496ZM44.7464 31.5002V35.4997H41.251V30.4561L44.7518 31.3941C44.7488 31.4292 44.7464 31.4645 44.7464 31.5002Z" fill="#0F52BA"></path><path d="M52.9795 20.5865L33.6634 15.4107C32.9963 15.232 32.3114 15.6278 32.1328 16.2945C31.954 16.9612 32.3498 17.6466 33.0165 17.8252L52.3327 23.001C52.441 23.03 52.5498 23.0438 52.6569 23.0438C53.2087 23.0438 53.7138 22.6755 53.8634 22.1172C54.0419 21.4505 53.6463 20.7652 52.9795 20.5865Z" fill="#0F52BA"></path><path d="M52.9795 25.7988L33.6634 20.623C32.9963 20.4443 32.3114 20.8401 32.1328 21.5068C31.954 22.1735 32.3498 22.8589 33.0165 23.0375L52.3327 28.2133C52.441 28.2423 52.5498 28.2561 52.6569 28.2561C53.2087 28.2561 53.7138 27.8878 53.8634 27.3295C54.0419 26.6628 53.6463 25.9774 52.9795 25.7988Z" fill="#0F52BA"></path><path d="M52.98 15.3744L47.2459 13.838V7.50327H50.4976C52.5651 7.50327 54.2471 5.82127 54.2471 3.75377C54.2471 1.68627 52.5651 0.00427246 50.4976 0.00427246H35.4995C33.432 0.00427246 31.75 1.68627 31.75 3.75377C31.75 5.82127 33.4319 7.50327 35.4994 7.50327H38.7511V11.5618L33.6639 10.1986C32.9968 10.0199 32.3119 10.4158 32.1332 11.0824C31.9545 11.7491 32.3502 12.4345 33.017 12.6131L52.3331 17.7889C52.4415 17.8179 52.5503 17.8318 52.6574 17.8318C53.2091 17.8318 53.7143 17.4634 53.8639 16.9051C54.0425 16.2384 53.6469 15.553 52.98 15.3744ZM35.4994 5.00352C34.8102 5.00352 34.2495 4.4429 34.2495 3.75365C34.2495 3.06452 34.8102 2.50377 35.4994 2.50377H50.4974C51.1865 2.50377 51.7473 3.0644 51.7473 3.75365C51.7473 4.44277 51.1866 5.00352 50.4974 5.00352H35.4994ZM44.7463 13.1681L41.2509 12.2315V7.50327H44.7463V13.1681Z" fill="#0F52BA"></path></svg>
				</div>
				<div class="uk-width-expand">
					<span class="numbers blue"><strong>04</strong></span><br>
					<h4 class="black uk-margin-remove">Suspension and Steering</h4>
					
				</div>
			</div>
            
            <hr class="blue-hr">
			<p>We work with the components — from the springs to shock absorbers, linkages that connect to the vehicle, and even your wheels. Contact us now to learn how we can help your vehicle maintain good handling for quality and safety.</p>
			<a href="<?= home_url(); ?>/steering-suspension/" class="blue"><strong>MORE <i class="fa-sharp-duotone fa-regular fa-arrow-right-long"></i></strong></a>
        </div>
		
		<div>
			<div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>
				<div class="uk-width-auto">
					<svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M64 19.1964C64 17.3057 62.4619 15.7675 60.5713 15.7675H59.5309V13.802C59.5309 11.8259 58.0247 10.1949 56.1 9.99648V8.34748C56.1 6.42161 54.5332 4.85486 52.6075 4.85486H51.5832C49.6594 4.85486 48.0941 6.42161 48.0941 8.34748V9.97623H43.4684L42.5467 7.05798C42.0555 5.49786 41.0145 5.17036 40.2277 5.17036H23.7722C22.9855 5.17036 21.9444 5.49786 21.4538 7.05661L20.5287 9.97623H15.9058V8.34748C15.9058 6.42161 14.3389 4.85486 12.4131 4.85486H11.3925C9.46675 4.85486 7.9 6.42161 7.9 8.34748V9.99661C5.97538 10.1949 4.46912 11.8259 4.46912 13.8021V15.7676H3.42525C1.5365 15.7675 0 17.3057 0 19.1964C0 21.0441 1.47088 22.5539 3.30325 22.6186V48.5624C1.93213 48.7872 0.8825 49.9799 0.8825 51.4136V57.3609C0.8825 58.3447 1.68287 59.1451 2.66675 59.1451H60.8725C61.8563 59.1451 62.6567 58.3447 62.6567 57.3609V51.4136C62.6567 50.1454 61.8353 49.0661 60.6968 48.678V22.6185C62.5294 22.5521 64 21.043 64 19.1964ZM49.9545 8.34748C49.9545 7.44736 50.6851 6.71511 51.5834 6.71511H52.6076C53.5076 6.71511 54.2399 7.44736 54.2399 8.34748V9.97623H49.9546V8.34748H49.9545ZM23.2275 7.61673C23.4121 7.03061 23.579 7.03061 23.7722 7.03061H40.2277C40.421 7.03061 40.5879 7.03061 40.7726 7.61748L41.5176 9.97636H22.4801L23.2275 7.61673ZM9.76025 8.34748C9.76025 7.44736 10.4925 6.71511 11.3925 6.71511H12.4132C13.3134 6.71511 14.0456 7.44736 14.0456 8.34748V9.97623H9.76025V8.34748ZM6.32937 13.802C6.32937 12.7182 7.21113 11.8365 8.29488 11.8365H8.83012H14.9757H21.2099H42.7868H49.0244H55.17H55.7052C56.7891 11.8365 57.6707 12.7182 57.6707 13.802V15.7675H6.32937V13.802ZM60.7965 57.2849H2.74288V51.4136C2.74288 50.8457 3.20475 50.3839 3.77262 50.3839H5.53775C6.10763 50.3839 6.57113 50.8459 6.57113 51.4136V53.2212C6.57113 53.735 6.9875 54.1514 7.50125 54.1514H30.1059C30.6196 54.1514 31.036 53.7349 31.036 53.2212C31.036 52.7076 30.6196 52.2911 30.1059 52.2911H8.43125V51.4136C8.43125 49.82 7.13312 48.5235 5.53762 48.5235H5.1635V22.6216H30.1057C30.6195 22.6216 31.0359 22.2051 31.0359 21.6915C31.0359 21.1779 30.6195 20.7614 30.1057 20.7614H3.42525C2.56238 20.7614 1.86025 20.0594 1.86025 19.1964C1.86025 18.3315 2.56238 17.6277 3.42525 17.6277H60.5713C61.4361 17.6277 62.1398 18.3314 62.1398 19.1964C62.1398 20.0594 61.4361 20.7614 60.5713 20.7614H34.433C33.9193 20.7614 33.5029 21.1779 33.5029 21.6915C33.5029 22.2051 33.9193 22.6216 34.433 22.6216H58.8365V48.5235H57.9981C56.4045 48.5235 55.108 49.82 55.108 51.4136V52.2911H34.433C33.9193 52.2911 33.5029 52.7076 33.5029 53.2212C33.5029 53.7349 33.9193 54.1514 34.433 54.1514H56.0382C56.552 54.1514 56.9684 53.7349 56.9684 53.2212V51.4136C56.9684 50.8457 57.4302 50.3839 57.9981 50.3839H59.7666C60.3345 50.3839 60.7964 50.8459 60.7964 51.4136V57.2849H60.7965Z" fill="#0F52BA"></path><path d="M39.2397 35.8123C38.871 35.066 37.933 35.066 37.5799 35.066H33.3769L34.8225 29.1345C34.9499 28.6108 35.215 27.5209 34.351 27.1093C33.4511 26.6803 32.7139 27.6481 32.1774 28.3528L25.3011 37.3309C24.9555 37.783 24.3767 38.5398 24.7581 39.3115C25.1296 40.0629 26.0562 40.0629 26.405 40.0629H30.6035L29.1617 45.9934C28.9405 46.9149 29.1225 47.5228 29.7029 47.8C29.8634 47.8767 30.0206 47.9095 30.173 47.9095C30.9361 47.9095 31.5717 47.083 31.8077 46.7759L38.6801 37.7945C39.0526 37.3078 39.6152 36.572 39.2397 35.8123ZM31.5477 44.0549L32.4375 40.3945C32.5429 39.961 32.635 39.3238 32.2211 38.7969C31.8025 38.2641 31.1387 38.2026 30.676 38.2026H26.9767L32.4346 31.0764L31.4982 34.918C31.4145 35.2614 31.2586 35.9008 31.6594 36.4109C32.0641 36.9263 32.7194 36.9263 33.1107 36.9263H37.0022L31.5477 44.0549Z" fill="#0F52BA"></path><path d="M47.9809 33.1977H49.1029V34.3232C49.1029 34.837 49.5193 35.2534 50.033 35.2534C50.5468 35.2534 50.9632 34.8369 50.9632 34.3232V33.1977H52.0885C52.6023 33.1977 53.0187 32.7812 53.0187 32.2676C53.0187 31.7539 52.6023 31.3375 52.0885 31.3375H50.9632V30.212C50.9632 29.6982 50.5468 29.2819 50.033 29.2819C49.5193 29.2819 49.1029 29.6984 49.1029 30.212V31.3375H47.9809C47.4672 31.3375 47.0508 31.754 47.0508 32.2676C47.0508 32.7812 47.4672 33.1977 47.9809 33.1977Z" fill="#0F52BA"></path><path d="M14.7482 31.3375H11.2075C10.6937 31.3375 10.2773 31.754 10.2773 32.2676C10.2773 32.7814 10.6937 33.1978 11.2075 33.1978H14.7482C15.262 33.1978 15.6783 32.7813 15.6783 32.2676C15.6783 31.7539 15.262 31.3375 14.7482 31.3375Z" fill="#0F52BA"></path></svg>
				</div>
				<div class="uk-width-expand">
					<span class="numbers blue"><strong>05</strong></span><br>
					<h4 class="black uk-margin-remove">Battery Testing and Replacement</h4>
					
				</div>
			</div>
            
            <hr class="blue-hr">
			<p>We have all the tools needed to test your battery, allowing us to determine if you need a replacement. More importantly, we can identify when the problem isn't your battery, allowing us save you money with more affordable repairs when a full replacement is unnecessary.</p>
			<a href="<?= home_url(); ?>/services/" class="blue"><strong>MORE <i class="fa-sharp-duotone fa-regular fa-arrow-right-long"></i></strong></a>
        </div>
		
		<div>
			<div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>
				<div class="uk-width-auto">
					<svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M30.9571 55.8825C30.9741 54.7647 31.5811 53.6287 32.7501 52.5129C34.3853 50.9897 35.2259 49.331 35.2472 47.5828C35.2686 45.7962 34.4345 44.0649 32.7684 42.4372C32.3481 42.0265 31.6718 42.0339 31.2601 42.4543C30.8495 42.8757 30.8568 43.5508 31.2782 43.9625C32.5113 45.1679 33.13 46.3774 33.115 47.5572C33.1011 48.6995 32.4888 49.8409 31.2877 50.9609C29.6802 52.4937 28.8515 54.1385 28.8248 55.8494C28.7982 57.6062 29.6185 59.3438 31.2643 61.0153C31.4723 61.2266 31.7486 61.3332 32.0238 61.3332C32.2947 61.3332 32.5646 61.2308 32.7716 61.0259C33.1918 60.6121 33.1972 59.9368 32.7834 59.5166C31.5533 58.2687 30.939 57.0463 30.9571 55.8825Z" fill="#0F52BA"></path><path d="M42.668 55.8826C42.685 54.7647 43.292 53.6287 44.461 52.513C46.1048 50.9812 46.9495 49.3172 46.9709 47.5636C46.9933 45.7812 46.1634 44.0563 44.5048 42.4361C44.0845 42.0255 43.4083 42.0328 42.9965 42.4531C42.5859 42.8745 42.5933 43.5496 43.0147 43.9613C44.2392 45.1592 44.8525 46.3613 44.8387 47.5378C44.8248 48.6845 44.2083 49.8333 42.9987 50.9607C41.3912 52.4935 40.5624 54.1383 40.5358 55.8492C40.5092 57.606 41.3294 59.3436 42.9753 61.0151C43.1833 61.2263 43.4595 61.333 43.7348 61.333C44.0047 61.333 44.2755 61.2306 44.4825 61.0257C44.9028 60.6118 44.9082 59.9366 44.4943 59.5163C43.2643 58.2687 42.6499 57.0463 42.668 55.8826Z" fill="#0F52BA"></path><path d="M19.1993 55.8826C19.2163 54.7647 19.8233 53.6287 20.9923 52.513C22.636 50.9812 23.4808 49.3172 23.5022 47.5636C23.5245 45.7812 22.6947 44.0563 21.036 42.4361C20.6158 42.0255 19.9395 42.0328 19.5278 42.4531C19.1172 42.8745 19.1245 43.5496 19.5459 43.9613C20.7704 45.1592 21.3838 46.3613 21.3699 47.5378C21.356 48.6845 20.7395 49.8333 19.5299 50.9607C17.9224 52.4935 17.0937 54.1383 17.067 55.8492C17.0404 57.606 17.8607 59.3436 19.5065 61.0151C19.7145 61.2263 19.9908 61.333 20.266 61.333C20.5359 61.333 20.8068 61.2306 21.0138 61.0257C21.434 60.6118 21.4394 59.9366 21.0255 59.5163C19.7955 58.2687 19.1812 57.0463 19.1993 55.8826Z" fill="#0F52BA"></path><path d="M16.0023 6.93335H7.46897C6.88022 6.93335 6.40234 7.4101 6.40234 7.99997V12.2666C6.40234 12.8565 6.88022 13.3332 7.46897 13.3332H16.0023C16.5911 13.3332 17.069 12.8565 17.069 12.2666V7.99997C17.069 7.4101 16.5911 6.93335 16.0023 6.93335ZM14.9357 11.2H8.53572V9.0666H14.9357V11.2Z" fill="#0F52BA"></path><path d="M57.5981 9.06665H56.5315C55.9427 9.06665 55.4648 9.5434 55.4648 10.1333C55.4648 10.7232 55.9427 11.1999 56.5315 11.1999H57.5981C58.1868 11.1999 58.6647 10.7232 58.6647 10.1333C58.6647 9.5434 58.1868 9.06665 57.5981 9.06665Z" fill="#0F52BA"></path><path d="M52.2661 9.06665H51.1994C50.6107 9.06665 50.1328 9.5434 50.1328 10.1333C50.1328 10.7232 50.6107 11.2 51.1994 11.2H52.2661C52.8548 11.2 53.3327 10.7233 53.3327 10.1334C53.3327 9.54353 52.8549 9.06665 52.2661 9.06665Z" fill="#0F52BA"></path><path d="M46.934 9.06665H45.8674C45.2787 9.06665 44.8008 9.5434 44.8008 10.1333C44.8008 10.7232 45.2787 11.1999 45.8674 11.1999H46.934C47.5228 11.1999 48.0007 10.7232 48.0007 10.1333C48.0007 9.5434 47.5228 9.06665 46.934 9.06665Z" fill="#0F52BA"></path><path d="M58.6666 2.66663H5.33337C2.3925 2.66663 0 5.05925 0 8V16.5334C0 17.1232 0.477875 17.6 1.06662 17.6H62.9333C63.522 17.6 63.9999 17.1232 63.9999 16.5334V8C64 5.05925 61.6075 2.66663 58.6666 2.66663ZM61.8666 15.4666H2.13337V8C2.13337 6.23575 3.56912 4.8 5.33337 4.8H58.6668C60.431 4.8 61.8667 6.23575 61.8667 8V15.4666H61.8666Z" fill="#0F52BA"></path><path d="M57.8919 27.3386C57.2914 26.5727 56.4188 26.1332 55.4973 26.1332H8.50519C7.58256 26.1332 6.71106 26.5727 6.10944 27.3386C5.41506 28.2249 5.16656 29.4303 5.45231 30.5877L6.86456 35.7909C7.36806 37.6406 9.05769 38.9333 10.9744 38.9333H53.0267C54.9434 38.9333 56.6331 37.6406 57.1366 35.7898L58.5552 30.5632C58.8338 29.4303 58.5863 28.2251 57.8919 27.3386ZM56.4892 30.0287L55.0769 35.2319C54.8273 36.1557 53.9836 36.7999 53.0268 36.7999H10.9746C10.0178 36.7999 9.17506 36.1557 8.92544 35.2319L7.51956 30.0533C7.39694 29.5594 7.50031 29.0229 7.78944 28.6538C7.90356 28.5098 8.14681 28.2666 8.50519 28.2666H55.4961C55.8544 28.2666 56.0987 28.5098 56.2128 28.6538C56.5009 29.0228 56.6044 29.5594 56.4892 30.0287Z" fill="#0F52BA"></path><path d="M58.6666 2.66663H5.33337C2.3925 2.66663 0 5.05925 0 8V31.4666C0 34.4075 2.3925 36.8 5.33337 36.8H7.9745C8.32013 36.8 8.6465 36.6315 8.846 36.3499C9.0455 36.0683 9.09562 35.7056 8.9815 35.3792C8.97725 35.3665 8.92925 35.2437 8.925 35.232L7.51912 30.0534C7.3965 29.5585 7.49988 29.023 7.789 28.6539C7.90212 28.5099 8.14637 28.2666 8.50362 28.2666H55.4956C55.854 28.2666 56.0983 28.5099 56.2103 28.6539C56.4994 29.023 56.6027 29.5595 56.4876 30.0288L55.0625 35.2629C55.0583 35.2735 55.0241 35.361 55.0209 35.3727C54.9035 35.7002 54.9515 36.0619 55.1521 36.3466C55.3516 36.6314 55.6769 36.8 56.0246 36.8H58.6668C61.6075 36.8 64.0001 34.4075 64.0001 31.4666V8C64 5.05925 61.6075 2.66663 58.6666 2.66663ZM61.8666 31.4666C61.8666 33.2309 60.4309 34.6666 58.6666 34.6666H57.44L58.5536 30.5631C58.832 29.4304 58.5845 28.225 57.8901 27.3386C57.2896 26.5728 56.417 26.1333 55.4955 26.1333H8.5035C7.58187 26.1333 6.70938 26.5728 6.10988 27.3386C5.4155 28.224 5.16688 29.4304 5.45275 30.5877L6.56 34.6666H5.33337C3.56912 34.6666 2.13337 33.2309 2.13337 31.4666V8C2.13337 6.23575 3.56912 4.8 5.33337 4.8H58.6668C60.431 4.8 61.8667 6.23575 61.8667 8V31.4666H61.8666Z" fill="#0F52BA"></path><path d="M56.9144 31.4666H7.08616C6.49741 31.4666 6.01953 31.9433 6.01953 32.5332C6.01953 33.1231 6.49741 33.5998 7.08616 33.5998H56.9144C57.5032 33.5998 57.981 33.1231 57.981 32.5332C57.981 31.9434 57.5032 31.4666 56.9144 31.4666Z" fill="#0F52BA"></path><path d="M24.5315 6.93335C23.9427 6.93335 23.4648 7.4101 23.4648 7.99997V12.2666C23.4648 12.8565 23.9427 13.3332 24.5315 13.3332C25.1202 13.3332 25.5981 12.8565 25.5981 12.2666V7.99997C25.5981 7.4101 25.1202 6.93335 24.5315 6.93335Z" fill="#0F52BA"></path><path d="M28.801 6.93335C28.2122 6.93335 27.7344 7.4101 27.7344 7.99997V12.2666C27.7344 12.8565 28.2122 13.3332 28.801 13.3332C29.3897 13.3332 29.8676 12.8565 29.8676 12.2666V7.99997C29.8676 7.4101 29.3897 6.93335 28.801 6.93335Z" fill="#0F52BA"></path><path d="M33.0666 6.93335C32.4779 6.93335 32 7.4101 32 7.99997V12.2666C32 12.8565 32.4779 13.3332 33.0666 13.3332C33.6554 13.3332 34.1333 12.8565 34.1333 12.2666V7.99997C34.1334 7.4101 33.6555 6.93335 33.0666 6.93335Z" fill="#0F52BA"></path><path d="M37.3362 6.93335C36.7474 6.93335 36.2695 7.4101 36.2695 7.99997V12.2666C36.2695 12.8565 36.7474 13.3332 37.3362 13.3332C37.9249 13.3332 38.4028 12.8565 38.4028 12.2666V7.99997C38.4028 7.4101 37.9249 6.93335 37.3362 6.93335Z" fill="#0F52BA"></path><path d="M39.4653 9.06665H22.3987C21.8099 9.06665 21.332 9.5434 21.332 10.1333C21.332 10.7232 21.8099 11.2 22.3987 11.2H39.4653C40.054 11.2 40.5319 10.7233 40.5319 10.1334C40.5319 9.54353 40.0541 9.06665 39.4653 9.06665Z" fill="#0F52BA"></path></svg>
				</div>
				<div class="uk-width-expand">
					<span class="numbers blue"><strong>06</strong></span><br>
					<h4 class="black uk-margin-remove">Air Conditioning and Heating</h4>
					
				</div>
			</div>
            
            <hr class="blue-hr">
			<p>Your AC and heating system has at least five main components that may need to be serviced. From keeping up Freon levels to helping to ensure that air pressure is maintained, we love helping our customers stay comfortable in all temperatures.</p>
			<a href="<?= home_url(); ?>/automotive-ac-service-and-repair/" class="blue"><strong>MORE <i class="fa-sharp-duotone fa-regular fa-arrow-right-long"></i></strong></a>
        </div>
		
		
		
		
      </div>

		
		<p class="uk-text-center"><a class="btn uk-display-inline-block" href="<?php echo home_url(); ?>/services/">SEE ALL SERVICES</a></p>
		
	</div>
</div>
	
	
			<section>

			<?php if (have_posts()): while (have_posts()) : the_post(); ?>

				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

					<?php the_content(); ?>

					<br class="clear">

					<?php edit_post_link( __('Edit this page'), '', '', 0, 'post-edit-link uk-label uk-float-right' ); ?>

				</article>

			<?php endwhile; ?><?php endif; ?>

			</section>
<?php get_footer(); ?>