<?php /*template name: List Sub Pages*/ get_header(); ?>

<div class="uk-container uk-container-large">
	<main role="main">
		<section>

			
			<?php if ( function_exists('yoast_breadcrumb') ) { yoast_breadcrumb('<p id="breadcrumbs" class="uk-margin uk-margin-top">','</p>'); } ?>
			<h1><?php the_title(); ?></h1>
			
			<?php if (have_posts()): while (have_posts()) : the_post(); ?>

				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

					<?php the_content(); ?>
					
					<div class="uk-child-width-1-2@m uk-grid-small uk-margin-large-top" uk-grid> 
						
							<?php
							$id = get_the_ID();
							$args = array(
								'post_type'      => 'page',
								'posts_per_page' => -1,
								'post_parent'    => $id,
								'order'          => 'ASC',
								'orderby'        => 'menu_order'
							 );


							$parent = new WP_Query( $args );

							if ( $parent->have_posts() ) : ?>

								<?php while ( $parent->have_posts() ) : $parent->the_post(); ?>
								
								<div>
									<div id="parent-<?php the_ID(); ?>" class="parent-page blue-box uk-display-block">
										<div class="uk-padding-small">
											<h2 class="uk-margin-remove"><?php the_title(); ?></h2>
											<p class="uk-margin-remove">Click to see more about repair and service</p>
										</div>
										<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="uk-position-cover"></a>
									</div>
									
								</div>
		

								<?php endwhile; ?>

							<?php endif; wp_reset_postdata(); ?>
						
						</div>
					
					

					<br class="clear">

					<p class="uk-text-right"><?php edit_post_link( __('Edit this page'), '', '', 0, 'post-edit-link uk-text-large uk-padding-small uk-button-large uk-button uk-button-primary' ); ?></p>

				</article>

			<?php endwhile; ?><?php endif; ?>

		</section>
	</main>
</div>
<?php get_footer(); ?>
