<?php if (have_posts()): while (have_posts()) : the_post(); ?>

	<article id="post-<?php the_ID(); ?>" <?php post_class('uk-grid-small'); ?> uk-grid>

		<div class="uk-width-1-1">
		<h3>
			<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="uk-text-decoration-none"><?php the_title(); ?></a>
			
		</h3>
		</div>
		<?php if ( has_post_thumbnail() ) { ?>
			<div class="uk-width-1-1 uk-width-1-3@m">

				<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
					<img uk-img data-src="<?php the_post_thumbnail_url('thumbnail'); ?>" data-width data-height>
				</a>
			</div>

		<?php } else { ?>
		<?php } ?>

		<div class="uk-width-1-1 uk-width-expand@m">

		
		<p><?php echo get_the_date('F jS Y'); ?></p>

		<?php html5wp_excerpt('html5wp_index'); ?>
		</div>
	</article>

<?php endwhile; ?>

<?php else: ?>
	<article>
		<h2><?php _e( 'Sorry, nothing to display.', 'html5blank' ); ?></h2>
	</article>
<?php endif; ?>
