<?php /*template name: Require Login*/ get_header(); ?>

<div class="uk-container uk-container-large">
	<main role="main">
		<section>

			<h1><?php the_title(); ?></h1>

			<?php if (have_posts()): while (have_posts()) : the_post(); ?>

				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				
				<?php
				if ( is_user_logged_in() ) {
					the_content();
				} else { 
					 $args = array(
    'echo' => true,
    // This could be your User's Current Page?
    'redirect' => site_url( $_SERVER['REQUEST_URI'] ),
    'form_id' => 'user-login-form',
    'label_username' => __( 'Username' ),
    'label_password' => __( 'Password' ),
    'label_remember' => __( 'Remember Me' ),
    'label_log_in' => __( 'Log In' ),
    'id_username' => 'user_login',
    'id_password' => 'user_pass',
    'id_remember' => 'rememberme',
    'id_submit' => 'wp-submit',
    'remember' => true,
    'value_username' => NULL,
    'value_remember' => false );

wp_login_form( $args );
				 }
				?>



					

					<br class="clear">

					<p class="uk-text-right"><?php edit_post_link( __('Edit this page'), '', '', 0, 'post-edit-link uk-text-large uk-padding-small uk-button-large uk-button uk-button-primary' ); ?></p>

				</article>

			<?php endwhile; ?><?php endif; ?>

		</section>
	</main>
</div>
<?php get_footer(); ?>
